/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.gui;

import com.yukami.backpacktab.client.config.TabConfig;
import com.yukami.backpacktab.client.gui.TabRenderer;
import com.yukami.backpacktab.client.tabs.BackpackTab;
import com.yukami.backpacktab.client.tabs.ContainerTab;
import com.yukami.backpacktab.client.tabs.InventoryTab;
import com.yukami.backpacktab.client.tabs.PlayerTab;
import com.yukami.backpacktab.client.util.CarriedItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.IBackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

@Mod.EventBusSubscriber(modid="yukamibackpacktab", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TabManager {
    private static AbstractContainerScreen<?> currentScreen = null;
    private static BlockPos storedBlockPos = null;
    private static Block storedBlockType = null;
    private static boolean isTabSwitching = false;
    private static final List<InventoryTab> activeTabs = new ArrayList<InventoryTab>();
    private static List<? extends String> cachedAdditionalTabBlocks = null;

    public static List<InventoryTab> getAvailableTabs(Player player, AbstractContainerScreen<?> screen) {
        ArrayList<InventoryTab> tabs = new ArrayList<InventoryTab>();
        BackpackTab equippedBackpack = TabManager.getEquippedBackpackTab(player);
        if (equippedBackpack == null) {
            return tabs;
        }
        if (storedBlockPos != null && TabManager.isBackpackBlock(player.m_9236_(), storedBlockPos)) {
            tabs.add(new ContainerTab(storedBlockPos));
            tabs.add(equippedBackpack);
            return tabs;
        }
        if (screen instanceof InventoryScreen) {
            tabs.add(new PlayerTab());
        } else if (storedBlockPos != null) {
            tabs.add(new ContainerTab(storedBlockPos));
        } else {
            tabs.add(new PlayerTab());
        }
        tabs.add(equippedBackpack);
        return tabs;
    }

    public static void updateActiveStates(List<InventoryTab> tabs, AbstractContainerScreen<?> screen) {
        tabs.forEach(tab -> tab.setActive(tab.matchesCurrentScreen(screen)));
    }

    private static BackpackTab getEquippedBackpackTab(Player player) {
        try {
            BackpackTab[] foundTab = new BackpackTab[]{null};
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
                if ("main".equals(inventoryName)) {
                    return false;
                }
                foundTab[0] = new BackpackTab(backpack);
                return true;
            });
            return foundTab[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isStoredBlockValid() {
        if (storedBlockPos == null || storedBlockType == null) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        Level world = player.m_9236_();
        if (world == null) {
            return false;
        }
        BlockState blockState = world.m_8055_(storedBlockPos);
        if (blockState.m_60734_() != storedBlockType) {
            return false;
        }
        double distanceSq = player.m_20275_((double)storedBlockPos.m_123341_() + 0.5, (double)storedBlockPos.m_123342_() + 0.5, (double)storedBlockPos.m_123343_() + 0.5);
        return distanceSq <= 64.0;
    }

    private static boolean isContainerBlock(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_60734_() instanceof BackpackBlock) {
            return true;
        }
        if (TabManager.isAdditionalTabBlock(blockState)) {
            return true;
        }
        try {
            return blockState.m_60750_(world, pos) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isBackpackBlock(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60734_() instanceof BackpackBlock;
    }

    private static boolean isAdditionalTabBlock(BlockState blockState) {
        try {
            ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
            if (blockId == null) {
                return false;
            }
            String blockIdString = blockId.toString();
            for (String string : TabManager.getAdditionalTabBlocks()) {
                if (string == null || !string.trim().equals(blockIdString)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static List<? extends String> getAdditionalTabBlocks() {
        if (cachedAdditionalTabBlocks == null) {
            cachedAdditionalTabBlocks = TabConfig.getAdditionalTabBlocks();
        }
        return cachedAdditionalTabBlocks;
    }

    private static boolean isScreenAllowedForTabs(AbstractContainerScreen<?> screen) {
        if (screen instanceof InventoryScreen) {
            return true;
        }
        if (screen instanceof IBackpackScreen) {
            return true;
        }
        return storedBlockPos != null && TabManager.isStoredBlockValid();
    }

    private static void handleInvalidBlock() {
        LocalPlayer player;
        if (currentScreen instanceof IBackpackScreen && (player = Minecraft.m_91087_().f_91074_) != null) {
            player.m_6915_();
        }
        TabManager.resetState();
    }

    private static void resetState() {
        storedBlockPos = null;
        storedBlockType = null;
        currentScreen = null;
        isTabSwitching = false;
        activeTabs.clear();
        CarriedItemUtil.reset();
        TabRenderer.invalidateCache();
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_5776_()) {
            BlockPos clickedPos = event.getPos();
            Level world = event.getLevel();
            if (TabManager.isContainerBlock(world, clickedPos)) {
                storedBlockPos = clickedPos;
                storedBlockType = world.m_8055_(clickedPos).m_60734_();
            }
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        LocalPlayer player;
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        currentScreen = containerScreen;
        if (!isTabSwitching) {
            activeTabs.clear();
        }
        if ((player = Minecraft.m_91087_().f_91074_) != null && !isTabSwitching) {
            activeTabs.clear();
            activeTabs.addAll(TabManager.getAvailableTabs((Player)player, containerScreen));
            TabManager.updateActiveStates(activeTabs, containerScreen);
        }
        isTabSwitching = false;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = player;
            MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
            if (gameMode != null) {
                CarriedItemUtil.unstashCarriedItem(localPlayer, gameMode, containerScreen.m_6262_());
            }
        }
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        if (!TabManager.isScreenAllowedForTabs(containerScreen)) {
            return;
        }
        if (containerScreen != currentScreen && !(containerScreen instanceof InventoryScreen)) {
            return;
        }
        if (storedBlockPos != null && !TabManager.isStoredBlockValid()) {
            TabManager.handleInvalidBlock();
            return;
        }
        TabRenderer.renderTabs(event.getGuiGraphics(), containerScreen, event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        if (containerScreen != currentScreen) {
            return;
        }
        if (!TabManager.isScreenAllowedForTabs(containerScreen)) {
            return;
        }
        isTabSwitching = true;
        if (TabRenderer.handleTabClick(event.getMouseX(), event.getMouseY(), event.getButton(), containerScreen)) {
            event.setCanceled(true);
        } else {
            isTabSwitching = false;
        }
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing event) {
        if (event.getScreen() == currentScreen) {
            if (!isTabSwitching) {
                TabManager.resetState();
                Screen screen = event.getScreen();
                if (screen instanceof AbstractContainerScreen) {
                    AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    if (player != null && screen2 instanceof InventoryScreen && CarriedItemUtil.isStashed() && player.f_36096_.m_142621_().m_41619_()) {
                        player.f_36096_.m_142503_(ItemStack.f_41583_);
                    }
                }
                CarriedItemUtil.reset();
            }
            currentScreen = null;
        }
    }

    public static List<InventoryTab> getActiveTabs() {
        return new ArrayList<InventoryTab>(activeTabs);
    }

    public static BlockPos getStoredBlockPos() {
        return storedBlockPos;
    }

    public static Block getStoredBlockType() {
        return storedBlockType;
    }

    public static void reset() {
        TabManager.resetState();
    }
}

