/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.gui;

import com.yukami.backpacktab.client.config.TabConfig;
import com.yukami.backpacktab.client.gui.TabManager;
import com.yukami.backpacktab.client.gui.TabSwitcher;
import com.yukami.backpacktab.client.tabs.InventoryTab;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TabRenderer {
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/creative_inventory/tabs.png");
    private static final int TAB_WIDTH = 26;
    private static final int TAB_HEIGHT = 32;
    private static final int ITEM_OFFSET_X = 5;
    private static final int ITEM_OFFSET_Y = 7;
    private static final int TOP_TAB_BASE_OFFSET = 4;
    private static final int TOP_ACTIVE_Y_ADJUST = 0;
    private static final int TOP_INACTIVE_Y_ADJUST = 1;
    private static final int TOP_INACTIVE_HEIGHT = 27;
    private static final int BOTTOM_TAB_BASE_OFFSET = -4;
    private static final int BOTTOM_ACTIVE_Y_ADJUST = 0;
    private static final int BOTTOM_INACTIVE_Y_ADJUST = 3;
    private static final int BOTTOM_INACTIVE_HEIGHT = 30;
    private static TabConfig.TabPosition cachedTabPosition = null;

    private static TabConfig.TabPosition getTabPosition() {
        if (cachedTabPosition == null) {
            cachedTabPosition = TabConfig.getTabPosition();
        }
        return cachedTabPosition;
    }

    private static int getTabX(int tabIndex, TabConfig.TabPosition position, AbstractContainerScreen<?> screen) {
        int screenLeft = screen.getGuiLeft();
        int screenWidth = screen.getXSize();
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case TabConfig.TabPosition.TOP_LEFT, TabConfig.TabPosition.BOTTOM_LEFT -> screenLeft + tabIndex * 26;
            case TabConfig.TabPosition.TOP_RIGHT, TabConfig.TabPosition.BOTTOM_RIGHT -> screenLeft + screenWidth - 26 - tabIndex * 26;
        };
    }

    private static int getTabY(TabConfig.TabPosition position, AbstractContainerScreen<?> screen, boolean active) {
        int screenTop = screen.getGuiTop();
        int screenHeight = screen.getYSize();
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case TabConfig.TabPosition.TOP_LEFT, TabConfig.TabPosition.TOP_RIGHT -> screenTop - 32 + 4 + (active ? 0 : 1);
            case TabConfig.TabPosition.BOTTOM_LEFT, TabConfig.TabPosition.BOTTOM_RIGHT -> screenTop + screenHeight + -4 + (active ? 0 : 3);
        };
    }

    private static int getTabHeight(TabConfig.TabPosition position, boolean active) {
        if (active) {
            return 32;
        }
        return position.isBottom() ? 30 : 27;
    }

    public static void invalidateCache() {
        cachedTabPosition = null;
    }

    public static void renderTabs(GuiGraphics guiGraphics, AbstractContainerScreen<?> screen, int mouseX, int mouseY) {
        List<InventoryTab> tabs = TabManager.getActiveTabs();
        if (tabs.isEmpty()) {
            return;
        }
        TabConfig.TabPosition position = TabRenderer.getTabPosition();
        for (int i = 0; i < tabs.size(); ++i) {
            InventoryTab tab = tabs.get(i);
            boolean active = tab.isActive();
            int x = TabRenderer.getTabX(i, position, screen);
            int y = TabRenderer.getTabY(position, screen, active);
            int height = TabRenderer.getTabHeight(position, active);
            TabConfig.SpriteCoords coords = TabConfig.getSpriteCoords(position, active, i == 0);
            int spriteV = coords.v;
            if (!active && position.isBottom()) {
                spriteV += 32 - height;
            }
            guiGraphics.m_280218_(CREATIVE_INVENTORY_TABS, x, y, coords.u, spriteV, 26, height);
            guiGraphics.m_280480_(tab.getTabIcon(), x + 5, y + 7);
            if (mouseX < x || mouseX >= x + 26 || mouseY < y || mouseY >= y + height) continue;
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, tab.getHoverText(), mouseX, mouseY);
        }
    }

    public static boolean handleTabClick(double mouseX, double mouseY, int button, AbstractContainerScreen<?> screen) {
        if (button != 0) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        List<InventoryTab> tabs = TabManager.getActiveTabs();
        if (tabs.isEmpty()) {
            return false;
        }
        TabConfig.TabPosition position = TabRenderer.getTabPosition();
        for (int i = 0; i < tabs.size(); ++i) {
            InventoryTab tab = tabs.get(i);
            boolean active = tab.isActive();
            int x = TabRenderer.getTabX(i, position, screen);
            int y = TabRenderer.getTabY(position, screen, active);
            int height = TabRenderer.getTabHeight(position, active);
            if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 26)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + height))) continue;
            tabs.forEach(t -> t.setActive(t == tab));
            TabSwitcher.switchToTab(tab, (Player)player, minecraft.f_91072_);
            return true;
        }
        return false;
    }
}

