/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.tabs;

import com.yukami.backpacktab.client.gui.TabManager;
import com.yukami.backpacktab.client.tabs.InventoryTab;
import com.yukami.backpacktab.client.util.CarriedItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.IBackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackOpenMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackTab
implements InventoryTab {
    private final ItemStack backpackStack;
    private boolean active = false;

    public BackpackTab(ItemStack backpackStack) {
        this.backpackStack = backpackStack;
    }

    @Override
    public ItemStack getTabIcon() {
        return this.backpackStack;
    }

    @Override
    public Component getHoverText() {
        return this.backpackStack.m_41786_();
    }

    @Override
    public void open(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
        if (player == null || gameMode == null || !(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        try {
            CarriedItemUtil.stashCarriedItem(localPlayer, gameMode, handler);
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
                if (ItemStack.m_41656_((ItemStack)backpack, (ItemStack)this.backpackStack)) {
                    SBPPacketHandler.INSTANCE.sendToServer((Object)new BackpackOpenMessage(slot, identifier, inventoryName));
                    return true;
                }
                return false;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
    }

    @Override
    public boolean matchesCurrentScreen(AbstractContainerScreen<?> screen) {
        BlockState blockState;
        ClientLevel world;
        if (!(screen instanceof IBackpackScreen)) {
            return false;
        }
        BlockPos storedPos = TabManager.getStoredBlockPos();
        return storedPos == null || (world = Minecraft.m_91087_().f_91073_) == null || !((blockState = world.m_8055_(storedPos)).m_60734_() instanceof BackpackBlock);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }
}

