/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.tabs;

import com.yukami.backpacktab.client.tabs.InventoryTab;
import com.yukami.backpacktab.client.util.CarriedItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.IBackpackScreen;

public class ContainerTab
implements InventoryTab {
    private final BlockPos containerPos;
    private boolean active = false;
    private ItemStack cachedIcon = null;

    public ContainerTab(BlockPos containerPos) {
        this.containerPos = containerPos;
    }

    @Override
    public ItemStack getTabIcon() {
        if (this.cachedIcon == null) {
            this.cachedIcon = this.computeIcon();
        }
        return this.cachedIcon;
    }

    private ItemStack computeIcon() {
        ClientLevel world;
        if (this.containerPos != null && (world = Minecraft.m_91087_().f_91073_) != null) {
            BlockState blockState = world.m_8055_(this.containerPos);
            if (blockState.m_60734_() instanceof BackpackBlock) {
                try {
                    BackpackBlockEntity backpackBE;
                    ItemStack backpackStack;
                    BlockEntity blockEntity = world.m_7702_(this.containerPos);
                    if (blockEntity instanceof BackpackBlockEntity && !(backpackStack = (backpackBE = (BackpackBlockEntity)blockEntity).getBackpackWrapper().getBackpack()).m_41619_()) {
                        return backpackStack;
                    }
                }
                catch (Exception blockEntity) {
                    // empty catch block
                }
            }
            ItemStack icon = new ItemStack((ItemLike)blockState.m_60734_());
            return icon;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public Component getHoverText() {
        ItemStack icon = this.getTabIcon();
        return icon.m_41619_() ? Component.m_237113_((String)"Container") : icon.m_41786_();
    }

    @Override
    public void open(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
        if (player == null || gameMode == null || !(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        try {
            if (this.containerPos != null) {
                CarriedItemUtil.stashCarriedItem(localPlayer, gameMode, handler);
                if (handler != null && localPlayer.f_108617_ != null) {
                    localPlayer.f_108617_.m_104955_((Packet)new ServerboundContainerClosePacket(handler.f_38840_));
                }
                Vec3 hitVec = Vec3.m_82512_((Vec3i)this.containerPos);
                BlockHitResult hitResult = new BlockHitResult(hitVec, Direction.UP, this.containerPos, false);
                gameMode.m_233732_(localPlayer, InteractionHand.MAIN_HAND, hitResult);
            } else {
                Minecraft.m_91087_().m_91152_(null);
            }
        }
        catch (Exception e) {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    @Override
    public void close(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
    }

    @Override
    public boolean matchesCurrentScreen(AbstractContainerScreen<?> screen) {
        BlockState blockState;
        if (this.containerPos == null) {
            return false;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null && (blockState = world.m_8055_(this.containerPos)).m_60734_() instanceof BackpackBlock) {
            return screen instanceof IBackpackScreen;
        }
        return !(screen instanceof IBackpackScreen);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }
}

