/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.tabs;

import com.mojang.authlib.GameProfile;
import com.yukami.backpacktab.client.tabs.InventoryTab;
import com.yukami.backpacktab.client.util.CarriedItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PlayerTab
implements InventoryTab {
    private boolean active = false;
    private ItemStack cachedIcon = null;
    private String cachedPlayerName = null;

    @Override
    public ItemStack getTabIcon() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return ItemStack.f_41583_;
        }
        String currentName = player.m_7755_().getString();
        if (this.cachedIcon == null || !currentName.equals(this.cachedPlayerName)) {
            this.cachedIcon = this.computeIcon(player);
            this.cachedPlayerName = currentName;
        }
        return this.cachedIcon;
    }

    private ItemStack computeIcon(LocalPlayer player) {
        ItemStack playerHead = new ItemStack((ItemLike)Items.f_42680_);
        CompoundTag tag = playerHead.m_41784_();
        GameProfile gameProfile = player.m_36316_();
        if (gameProfile.getId() != null) {
            CompoundTag skullOwnerTag = new CompoundTag();
            skullOwnerTag.m_128359_("Name", gameProfile.getName());
            skullOwnerTag.m_128362_("Id", gameProfile.getId());
            tag.m_128365_("SkullOwner", (Tag)skullOwnerTag);
        }
        playerHead.m_41751_(tag);
        return playerHead;
    }

    @Override
    public Component getHoverText() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return Component.m_237113_((String)"Player");
        }
        return Component.m_237113_((String)player.m_7755_().getString());
    }

    @Override
    public void open(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
        if (player == null || gameMode == null || !(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        CarriedItemUtil.stashCarriedItem(localPlayer, gameMode, handler);
        if (handler != null && !(handler instanceof InventoryMenu) && localPlayer.f_108617_ != null) {
            localPlayer.f_108617_.m_104955_((Packet)new ServerboundContainerClosePacket(handler.f_38840_));
        }
        if (gameMode.m_105295_() == GameType.SURVIVAL || gameMode.m_105295_() == GameType.ADVENTURE) {
            Minecraft.m_91087_().m_91152_((Screen)new InventoryScreen((Player)localPlayer));
        }
    }

    @Override
    public void close(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
    }

    @Override
    public boolean matchesCurrentScreen(AbstractContainerScreen<?> screen) {
        return screen instanceof InventoryScreen;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isInstant() {
        return true;
    }
}

