/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.config;

import dlovin.castiainvtools.enums.LeftMode;
import dlovin.castiainvtools.enums.SkillMessageType;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class THLConfig {
    public ModConfigSpec clientSpec;
    private final Client client;

    public THLConfig() {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        this.clientSpec = (ModConfigSpec)specPair.getRight();
        this.client = (Client)specPair.getLeft();
    }

    public Client getClient() {
        return this.client;
    }

    public void register(ModContainer context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientSpec);
    }

    public static class Client {
        public final ModConfigSpec.IntValue pvMax;
        public final ModConfigSpec.IntValue tvMax;
        public final ModConfigSpec.IntValue jobStatsCustomValue;
        public final ModConfigSpec.IntValue jobStatsSaveDelay;
        public final ModConfigSpec.BooleanValue invBtn;
        public final ModConfigSpec.BooleanValue crBtn;
        public final ModConfigSpec.BooleanValue ecBtn;
        public final ModConfigSpec.BooleanValue pvBtn;
        public final ModConfigSpec.BooleanValue tvBtn;
        public final ModConfigSpec.BooleanValue trBtn;
        public final ModConfigSpec.BooleanValue keepMithril;
        public final ModConfigSpec.BooleanValue commonTier;
        public final ModConfigSpec.BooleanValue rareTier;
        public final ModConfigSpec.BooleanValue epicTier;
        public final ModConfigSpec.BooleanValue legendaryTier;
        public final ModConfigSpec.BooleanValue mithrilTier;
        public final ModConfigSpec.BooleanValue begrimedTier;
        public final ModConfigSpec.BooleanValue codexTier;
        public final ModConfigSpec.BooleanValue emojiButtons;
        public final ModConfigSpec.BooleanValue jobStats;
        public final ModConfigSpec.EnumValue<SkillMessageType> skillMessages;
        public final ModConfigSpec.EnumValue<LeftMode> leftMode;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.pvMax = builder.comment("Private Vault Max Count").translation("castiainvtools.config.client.npv").defineInRange("pvMax", 5, 1, 50);
            this.tvMax = builder.comment("Town Vault Max Count").translation("castiainvtools.config.client.ntv").defineInRange("tvMax", 5, 1, 50);
            this.jobStatsCustomValue = builder.comment("Minutes for custom stats").translation("castiainvtools.config.client.earnings_custom").defineInRange("jobStatsCustomValue", 10, 1, 30);
            this.jobStatsSaveDelay = builder.comment("Delay between saving stats").translation("castiainvtools.config.client.earnings_save").defineInRange("jobStatsSaveDelay", 0, 0, 10);
            this.invBtn = builder.comment("Toggle on/off Inventory button").translation("castiainvtools.config.client.invbtn").define("invBtn", true);
            this.crBtn = builder.comment("Toggle on/off Craft button").translation("castiainvtools.config.client.crbtn").define("crBtn", true);
            this.ecBtn = builder.comment("Toggle on/off Ender chest button").translation("castiainvtools.config.client.ecbtn").define("ecBtn", true);
            this.pvBtn = builder.comment("Toggle on/off PlayerVault button").translation("castiainvtools.config.client.pvbtn").define("pvBtn", true);
            this.tvBtn = builder.comment("Toggle on/off Town Vault button").translation("castiainvtools.config.client.tvbtn").define("tvBtn", true);
            this.trBtn = builder.comment("Toggle on/off Trash button").translation("castiainvtools.config.client.trbtn").define("trBtn", true);
            this.keepMithril = builder.comment("Keep Mithril Icons red").translation("castiainvtools.config.client.keepmithril").define("keepMithril", false);
            this.commonTier = builder.comment("Show Common Tier Icons").translation("castiainvtools.config.client.tiers.common").define("commonTier", true);
            this.rareTier = builder.comment("Show Rare Tier Icons").translation("castiainvtools.config.client.tiers.rare").define("rareTier", true);
            this.epicTier = builder.comment("Show Epic Tier Icons").translation("castiainvtools.config.client.tiers.epic").define("epicTier", true);
            this.legendaryTier = builder.comment("Show Legendary Tier Icons").translation("castiainvtools.config.client.tiers.legendary").define("legendaryTier", true);
            this.mithrilTier = builder.comment("Show Mithril Tier Icons").translation("castiainvtools.config.client.tiers.mithril").define("mithrilTier", true);
            this.begrimedTier = builder.comment("Show Begrimed Tier Icons").translation("castiainvtools.config.client.tiers.begrimed").define("begrimedTier", true);
            this.codexTier = builder.comment("Show Historical Codex Icons").translation("castiainvtools.config.client.tiers.codex").define("codexTier", true);
            this.emojiButtons = builder.comment("Emoji buttons").translation("castianinvtools.config.client.emojibuttons").define("emojiButtons", true);
            this.jobStats = builder.comment("Skills income stats").translation("castianinvtools.config.client.skills_stats").define("jobStats", true);
            this.skillMessages = builder.comment("Skills income messages").translation("castianinvtools.config.client.skills_message").defineEnum("skillMessages", (Enum)SkillMessageType.SERVER_DEFAULT);
            this.leftMode = builder.comment("Should inventory buttons be on left side").defineEnum("leftMode", (Enum)LeftMode.NONE);
            builder.pop();
        }
    }
}

