/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.events;

import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.gui.HomesGui;
import dlovin.castiainvtools.network.CITNetworkManager;
import dlovin.castiainvtools.utils.jobs.JobEarnings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

public class ClientEvents {
    private final ConfigValues configValues;
    private final JobEarnings jobEarnings;

    public ClientEvents(ConfigValues configValues, IEventBus eventBus) {
        this.jobEarnings = JobEarnings.initialize(configValues);
        this.configValues = configValues;
        eventBus.addListener(this::onJoinServer);
        eventBus.addListener(this::onLeaveServer);
    }

    @SubscribeEvent
    public void onJoinServer(ClientPlayerNetworkEvent.LoggingIn event) {
        String serverIP = event.getConnection().getRemoteAddress().toString().toLowerCase();
        boolean bl = this.configValues.isOnCastia = serverIP.contains("castiamc.com") || serverIP.contains("stickymc.com");
        if (!this.configValues.isOnCastia) {
            return;
        }
        CITNetworkManager.sendHello(Minecraft.getInstance().getUser(), event.getConnection());
    }

    @SubscribeEvent
    public void onLeaveServer(ClientPlayerNetworkEvent.LoggingOut event) {
        if (this.configValues.isOnCastia && this.configValues.jobStats) {
            this.jobEarnings.save();
        }
    }

    public boolean handleMessage(Component message, boolean isChat) {
        if (!this.configValues.isOnCastia) {
            return false;
        }
        String messageString = message.getString();
        if (this.checkJobsIncome(messageString)) {
            switch (this.configValues.skillsMessages) {
                case SERVER_DEFAULT: {
                    if (isChat) {
                        Minecraft.getInstance().gui.getChat().addMessage(message);
                        break;
                    }
                    Minecraft.getInstance().gui.setOverlayMessage(message, false);
                    break;
                }
                case CHAT: {
                    Minecraft.getInstance().gui.getChat().addMessage(message);
                    break;
                }
                case ACTION_BAR: {
                    Minecraft.getInstance().gui.setOverlayMessage(message, false);
                }
            }
            return true;
        }
        return this.checkCastiaHomes(messageString);
    }

    private boolean checkJobsIncome(String message) {
        if (!this.configValues.jobStats) {
            return false;
        }
        return this.jobEarnings.handleMessage(message);
    }

    private boolean checkCastiaHomes(String message) {
        if (!this.configValues.isFindingHomes) {
            return false;
        }
        if (!message.startsWith("\ue088 Homes: ")) {
            return false;
        }
        this.configValues.isFindingHomes = false;
        Minecraft.getInstance().setScreen((Screen)new HomesGui(message.replace("\ue088 Homes: ", "").split(", ")));
        return true;
    }
}

