/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.enums.LeftMode;
import dlovin.castiainvtools.enums.SkillMessageType;
import dlovin.castiainvtools.gui.TierConfigGui;
import dlovin.utils.widgets.ButtonWidget;
import dlovin.utils.widgets.CheckBox;
import dlovin.utils.widgets.CustomButton;
import dlovin.utils.widgets.CustomOptionList;
import dlovin.utils.widgets.NumericTextField;
import dlovin.utils.widgets.TextField;
import dlovin.utils.widgets.TextWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigGui
extends Screen {
    private CustomOptionList list;
    private final ConfigValues configValues = CastiaInvTools.configValues();

    public ConfigGui() {
        super((Component)Component.literal((String)"Castia Inventory Tools Config"));
    }

    protected void init() {
        int posX = this.width / 2;
        this.list = new CustomOptionList(this.minecraft, this, 32);
        int i = 0;
        this.list.addWidget(new TextWidget(posX, "Toggle on/off inventory buttons:", this.font), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Inventory:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onInventory, this.configValues.inventoryButton), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Craft:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onCraft, this.configValues.craftButton), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Ender chest:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onEnder, this.configValues.enderChestButton), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Player Vault:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onPV, this.configValues.playerVaultButton), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Town Vault:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onTV, this.configValues.townVaultButton), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Trash:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onTrash, this.configValues.trashButton), i++);
        this.list.addWidget(new TextWidget(posX, "Skill Earnings Options:", this.font), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Track skill earnings:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onJobStats, this.configValues.jobStats), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Skill Earnings last minutes:", this.font), i);
        this.list.addWidget(new NumericTextField(this.font, posX + 10, 0, 40, 20, 1, 30, this.configValues.jobStatsCustomValue, this::onJobValue), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Skill Earnings save delay:", this.font), i);
        this.list.addWidget(new NumericTextField(this.font, posX + 10, 0, 40, 20, 0, 10, this.configValues.jobStatsSaveDelay, this::onJobSave), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Skill income messages:", this.font), i);
        CustomButton sbtn = new CustomButton(posX + 10, 0, 90, 18, this.configValues.skillsMessages.humanize(), null, false);
        sbtn.addListener(this::onSkillMessage);
        this.list.addWidget(sbtn, i++);
        this.list.addWidget(new TextWidget(posX, "Other Options:", this.font), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Tier Icons Menu:", this.font), i);
        CustomButton tbtn = new CustomButton(posX + 10, 0, 50, 18, "Open", null, false);
        tbtn.addListener(this::onTierMenu);
        this.list.addWidget(tbtn, i++);
        this.list.addWidget(new TextWidget(posX - 20, "Left side mode:", this.font), i);
        CustomButton cbtn = new CustomButton(posX + 10, 0, 90, 18, this.configValues.leftMode.toString(), null, false);
        cbtn.addListener(this::onLeftMode);
        this.list.addWidget(cbtn, i++);
        this.list.addWidget(new TextWidget(posX - 20, "Emoji Buttons:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onEmojiButtons, this.configValues.emojiButtons), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Private Vault Max Count:", this.font), i);
        this.list.addWidget(new NumericTextField(this.font, posX + 10, 0, 40, 20, 1, 50, this.configValues.playerVaultsCount, this::onPvChanged), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Town Vault Max Count:", this.font), i);
        this.list.addWidget(new NumericTextField(this.font, posX + 10, 0, 40, 20, 1, 50, this.configValues.townVaultsCount, this::onTvChanged), i);
        this.children().add(this.list);
    }

    private void onJobSave(TextField btn) {
        try {
            int value;
            this.configValues.jobStatsSaveDelay = value = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().getClient().jobStatsSaveDelay.set((Object)value);
            CastiaInvTools.getConfig().clientSpec.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onJobValue(TextField btn) {
        try {
            int value;
            this.configValues.jobStatsCustomValue = value = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().getClient().jobStatsCustomValue.set((Object)value);
            CastiaInvTools.getConfig().clientSpec.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onJobStats(CheckBox box) {
        CastiaInvTools.getConfig().getClient().jobStats.set((Object)box.checked);
        this.configValues.jobStats = box.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onSkillMessage(ButtonWidget btn) {
        SkillMessageType stype = ((SkillMessageType)((Object)CastiaInvTools.getConfig().getClient().skillMessages.get())).next();
        CastiaInvTools.getConfig().getClient().skillMessages.set((Object)stype);
        this.configValues.skillsMessages = stype;
        btn.setMessage(stype.humanize());
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onEmojiButtons(CheckBox box) {
        CastiaInvTools.getConfig().getClient().emojiButtons.set((Object)box.checked);
        this.configValues.emojiButtons = box.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onTierMenu(ButtonWidget btn) {
        Minecraft.getInstance().setScreen((Screen)new TierConfigGui());
    }

    private void onLeftMode(ButtonWidget btn) {
        LeftMode mode = ((LeftMode)((Object)CastiaInvTools.getConfig().getClient().leftMode.get())).next();
        CastiaInvTools.getConfig().getClient().leftMode.set((Object)mode);
        this.configValues.leftMode = mode;
        btn.setMessage(mode.toString());
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onPvChanged(TextField btn) {
        try {
            int pv;
            this.configValues.playerVaultsCount = pv = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().getClient().pvMax.set((Object)pv);
            CastiaInvTools.getConfig().clientSpec.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onTvChanged(TextField btn) {
        try {
            int pv;
            this.configValues.townVaultsCount = pv = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().getClient().tvMax.set((Object)pv);
            CastiaInvTools.getConfig().clientSpec.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onTrash(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().trBtn.set((Object)btn.checked);
        this.configValues.trashButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onPV(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().pvBtn.set((Object)btn.checked);
        this.configValues.playerVaultButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onTV(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().tvBtn.set((Object)btn.checked);
        this.configValues.townVaultButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onEnder(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().ecBtn.set((Object)btn.checked);
        this.configValues.enderChestButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onCraft(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().crBtn.set((Object)btn.checked);
        this.configValues.craftButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onInventory(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().invBtn.set((Object)btn.checked);
        this.configValues.inventoryButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        context.fillGradient(0, 0, context.guiWidth(), 32, -587202560, -2013265920);
        this.renderTitle(context);
        this.list.render(context, mouseX, mouseY, partialTick);
    }

    public void renderTitle(@NotNull GuiGraphics gui) {
        gui.pose().pushMatrix();
        gui.pose().translate((float)this.width * 0.5f, 10.0f);
        gui.pose().pushMatrix();
        gui.pose().scale(2.0f, 2.0f);
        gui.drawCenteredString(this.font, this.title.getString(), 0, 0, -1);
        gui.pose().popMatrix();
        gui.pose().popMatrix();
    }

    public boolean charTyped(char character, int code) {
        if (this.list.charTyped(character, code)) {
            return true;
        }
        return super.charTyped(character, code);
    }

    public boolean mouseDragged(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        this.list.mouseDragged(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
        return false;
    }

    public boolean keyPressed(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (this.list.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        return super.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
    }
}

