/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui;

import dlovin.castiainvtools.utils.ChatUtils;
import dlovin.utils.widgets.ButtonWidget;
import dlovin.utils.widgets.CustomButton;
import dlovin.utils.widgets.CustomOptionList;
import dlovin.utils.widgets.TextField;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class HomesGui
extends Screen {
    protected CustomOptionList OptionList;
    protected TextField searchField;
    private final String[] homes;
    private String filter = "";
    private int maxwidth;

    public HomesGui(String[] homes) {
        super((Component)Component.literal((String)"Homes"));
        this.homes = (String[])Stream.of(homes).sorted().toArray(String[]::new);
        Font f = Minecraft.getInstance().font;
        for (String s : homes) {
            if (f.width(s) <= this.maxwidth) continue;
            this.maxwidth = f.width(s);
        }
        this.maxwidth += 20;
    }

    protected void init() {
        this.OptionList = new CustomOptionList(this.minecraft, this, 32, 30);
        this.initHomes();
        this.searchField = new TextField(this.font, this.width / 2 - this.maxwidth / 2, this.height - 25, this.maxwidth, 20, "", this::filterChanged);
        this.searchField.setMaxStringLength(255);
        this.searchField.setOnSubmit(this::handleSearchSubmit);
        this.children().add(this.OptionList);
        this.children().add(this.searchField);
        this.mouseClicked(this.searchField.x + 1, this.searchField.y + 1, 0);
    }

    private void initHomes() {
        int index = 0;
        for (String home : this.homes) {
            if (!this.filter.isEmpty() && !home.toLowerCase().contains(this.filter.toLowerCase())) continue;
            this.addButton(home, index);
            ++index;
        }
    }

    private void addButton(String home, int index) {
        CustomButton tmp = new CustomButton(this.width / 2 - this.maxwidth / 2, 0, this.maxwidth, 20, home, null, false);
        this.OptionList.addWidget(tmp, index);
        tmp.addListener(this::handleHomeClick);
    }

    private void filterChanged(TextField field) {
        this.filter = field.getText().toLowerCase();
        this.OptionList.clear();
        this.initHomes();
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        context.fillGradient(0, 0, context.guiWidth(), 32, -587202560, -2013265920);
        this.renderTitle(context);
        this.OptionList.render(context, mouseX, mouseY, partialTick);
        this.OptionList.renderTooltips(context, mouseX, mouseY);
        this.searchField.render(context, mouseX, mouseY, partialTick);
    }

    public void renderTitle(@NotNull GuiGraphics gui) {
        gui.pose().pushMatrix();
        gui.pose().translate((float)this.width * 0.5f, 10.0f);
        gui.pose().pushMatrix();
        gui.pose().scale(2.0f, 2.0f);
        gui.drawCenteredString(this.font, this.title.getString(), 0, 0, -1);
        gui.pose().popMatrix();
        gui.pose().popMatrix();
    }

    public boolean mouseClicked(double m1, double m2, int m3) {
        return super.mouseClicked(m1, m2, m3);
    }

    public boolean charTyped(char p_231042_1_, int p_231042_2_) {
        if (this.OptionList.charTyped(p_231042_1_, p_231042_2_)) {
            return true;
        }
        return super.charTyped(p_231042_1_, p_231042_2_);
    }

    public boolean mouseDragged(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        this.OptionList.mouseDragged(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
        return false;
    }

    public boolean keyPressed(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (this.OptionList.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        return super.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    private void handleHomeClick(ButtonWidget btn) {
        this.teleportToHome(btn.getMessage());
    }

    private void handleSearchSubmit(TextField _field) {
        if (this.OptionList.getWidgets().isEmpty()) {
            return;
        }
        this.teleportToHome(this.OptionList.getWidgets().getFirst().getMessage());
    }

    private void teleportToHome(String home) {
        ChatUtils.sendCommandByLocal(String.format(Locale.ROOT, "h %s", home));
        Minecraft.getInstance().setScreen(null);
    }
}

