/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui;

import dlovin.castiainvtools.gui.widgets.PlainText;
import dlovin.castiainvtools.utils.jobs.JobEarnings;
import dlovin.utils.helpers.RenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class JobEarningsScreen
extends Screen {
    private final JobEarnings jobEarnings;
    private final ResourceLocation BG = ResourceLocation.tryBuild((String)"castiainvtools", (String)"textures/gui/earnings_bg.png");
    private final int bgWidth = 208;
    private final int bgHeight = 124;
    private int bgX;
    private int bgY;

    public JobEarningsScreen() {
        super((Component)Component.literal((String)"Job Earnings"));
        this.jobEarnings = JobEarnings.getInstance();
    }

    protected void init() {
        int x = this.width / 2;
        int y = this.height / 2;
        this.bgX = x - 104;
        this.bgY = y - 62;
        Object[] stats = this.jobEarnings.getStats();
        String[] statNames = new String[stats.length];
        String[] statValues = new String[statNames.length];
        String[] fullLines = new String[statNames.length];
        int index = 0;
        for (Object stat : stats) {
            statNames[index] = String.format("%s: ", ((Object[])stat)[0]);
            statValues[index] = String.format("$%.2f", (double)((Double)((Object[])stat)[1]));
            fullLines[index] = String.format("%s%s", statNames[index], statValues[index]);
            ++index;
        }
        int maxWidth = 184;
        y -= fullLines.length * 6 - 2;
        x -= maxWidth / 2;
        for (int i = 0; i < statNames.length; ++i) {
            this.addRenderableOnly(new PlainText(x, y + i * 12, statNames[i], this.font));
            this.addRenderableOnly(new PlainText(x + maxWidth, y + i * 12, statValues[i], this.font, true));
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        context.pose().pushMatrix();
        RenderHelper.drawTexture(context, this.BG, this.bgX, this.bgY, 208, 124, 256, 256);
        context.pose().popMatrix();
        for (Renderable renderable : this.renderables) {
            renderable.render(context, mouseX, mouseY, partialTicks);
        }
    }
}

