/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.config.THLConfig;
import dlovin.castiainvtools.gui.CastiaItemTiers;
import dlovin.castiainvtools.gui.ConfigGui;
import dlovin.utils.widgets.CheckBox;
import dlovin.utils.widgets.CustomOptionList;
import dlovin.utils.widgets.TextWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class TierConfigGui
extends Screen {
    private CustomOptionList list;
    private ConfigValues configValues = CastiaInvTools.configValues();

    public TierConfigGui() {
        super((Component)Component.literal((String)"Castia Tiers Config"));
    }

    protected void init() {
        this.list = new CustomOptionList(this.minecraft, this, 32);
        int posX = this.width / 2;
        int i = 0;
        THLConfig.Client client = CastiaInvTools.getConfig().getClient();
        this.list.addWidget(new TextWidget(posX, "Toggle on/off tier icons:", this.font), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Common Tier:", this.font), i);
        this.list.addWidget(this.preparedCheckBox(posX, "common", client.commonTier), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Rare Tier:", this.font), i);
        this.list.addWidget(this.preparedCheckBox(posX, "rare", client.rareTier), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Epic Tier:", this.font), i);
        this.list.addWidget(this.preparedCheckBox(posX, "epic", client.epicTier), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Legendary Tier:", this.font), i);
        this.list.addWidget(this.preparedCheckBox(posX, "legendary", client.legendaryTier), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Mithril Tier:", this.font), i);
        this.list.addWidget(this.preparedCheckBox(posX, "mithril", client.mithrilTier), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Begrimed Items:", this.font), i);
        this.list.addWidget(this.preparedCheckBox(posX, "begrimed", client.begrimedTier), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Historical Codex:", this.font), i);
        this.list.addWidget(this.preparedCheckBox(posX, "codex", client.codexTier), i++);
        this.list.addWidget(new TextWidget(posX - 20, "Keep Mithril Icons Red:", this.font), i);
        this.list.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onCastian, (Boolean)CastiaInvTools.getConfig().getClient().keepMithril.get()), i++);
        this.children().add(this.list);
    }

    private CheckBox preparedCheckBox(int posX, String message, ModConfigSpec.BooleanValue accessor) {
        CheckBox box = new CheckBox(posX + 10, 2, 16, 16, btn -> this.onIcon(btn, accessor), (Boolean)accessor.get());
        box.setMessage(message);
        return box;
    }

    private void onIcon(CheckBox box, ModConfigSpec.BooleanValue value) {
        String key = box.getMessage();
        CastiaItemTiers.colorMap.get((Object)key).enabled = box.checked;
        value.set((Object)box.checked);
        CastiaInvTools.getConfig().clientSpec.save();
        this.configValues.resetIcons();
    }

    private void onCastian(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().keepMithril.set((Object)btn.checked);
        this.configValues.keepMithrilIconRed = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        context.fillGradient(0, 0, context.guiWidth(), 32, -587202560, -2013265920);
        this.renderTitle(context);
        this.list.render(context, mouseX, mouseY, partialTick);
    }

    public void renderTitle(@NotNull GuiGraphics gui) {
        gui.pose().pushMatrix();
        gui.pose().translate((float)this.width * 0.5f, 10.0f);
        gui.pose().pushMatrix();
        gui.pose().scale(2.0f, 2.0f);
        gui.drawCenteredString(this.font, this.title.getString(), 0, 0, -1);
        gui.pose().popMatrix();
        gui.pose().popMatrix();
    }

    public boolean charTyped(char p_231042_1_, int p_231042_2_) {
        if (this.list.charTyped(p_231042_1_, p_231042_2_)) {
            return true;
        }
        return super.charTyped(p_231042_1_, p_231042_2_);
    }

    public boolean mouseDragged(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        this.list.mouseDragged(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
        return false;
    }

    public boolean keyPressed(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (this.list.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        return super.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen((Screen)new ConfigGui());
    }
}

