/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui.widgets;

import dlovin.castiainvtools.gui.widgets.EmojiButton;
import dlovin.utils.widgets.ButtonWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class EmojiWidget {
    int x;
    int y;
    Minecraft mc = Minecraft.getInstance();
    Font font;
    List<EmojiButton> buttons;
    int columns = 9;
    private static final HashMap<String, String> EMOJIS = new HashMap();

    public EmojiWidget() {
        this.x = this.mc.gui.getChat().getWidth() + 13;
        this.columns = Math.max(Math.min((this.mc.getWindow().getGuiScaledWidth() - this.x) / 11, this.columns), 1);
        int rows = (int)Math.ceil((double)EMOJIS.size() / (double)this.columns);
        this.y = this.mc.getWindow().getGuiScaledHeight() - 40 - 11 * rows;
        this.font = this.mc.font;
        this.buttons = new ArrayList<EmojiButton>();
        int i = 0;
        for (Map.Entry<String, String> emoji : EMOJIS.entrySet()) {
            this.buttons.add(this.buildEmojiButton(emoji.getKey(), emoji.getValue(), i++));
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float pTicks) {
        context.pose().pushMatrix();
        for (ButtonWidget buttonWidget : this.buttons) {
            buttonWidget.render(context, mouseX, mouseY, pTicks);
        }
        context.pose().popMatrix();
    }

    public boolean handleClick() {
        for (ButtonWidget buttonWidget : this.buttons) {
            if (!buttonWidget.mouseClicked(0.0, 0.0, 0)) continue;
            if (this.mc.screen != null && Screen.hasShiftDown()) {
                this.mc.screen.keyPressed(257, 0, 0);
            }
            return true;
        }
        return false;
    }

    private EmojiButton buildEmojiButton(String key, String command, int index) {
        EmojiButton widget = new EmojiButton(this.x + index % this.columns * 11, this.y + index / this.columns * 11, 11, 11, key);
        widget.addListener(b -> {
            for (char c : command.toCharArray()) {
                if (this.mc.screen == null) continue;
                this.mc.screen.charTyped(c, 0);
            }
        });
        return widget;
    }

    static {
        EMOJIS.put("\ue001", ":grinning:");
        EMOJIS.put("\ue002", ":sweat_smile:");
        EMOJIS.put("\ue003", ":joy:");
        EMOJIS.put("\ue004", ":blush:");
        EMOJIS.put("\ue005", ":slight_smile:");
        EMOJIS.put("\ue006", ":upside_down:");
        EMOJIS.put("\ue007", ":wink:");
        EMOJIS.put("\ue008", ":heart_eyes:");
        EMOJIS.put("\ue009", ":kissing_heart:");
        EMOJIS.put("\ue00a", ":zany_face:");
        EMOJIS.put("\ue00b", ":raised_eyebrow:");
        EMOJIS.put("\ue00c", ":sunglasses:");
        EMOJIS.put("\ue00d", ":partying_face:");
        EMOJIS.put("\ue00e", ":smirk:");
        EMOJIS.put("\ue00f", ":pleading_face:");
        EMOJIS.put("\ue010", ":cry:");
        EMOJIS.put("\ue011", ":sob:");
        EMOJIS.put("\ue012", ":rage:");
        EMOJIS.put("\ue013", ":exploding_head:");
        EMOJIS.put("\ue014", ":flushed:");
        EMOJIS.put("\ue015", ":neutral_face:");
        EMOJIS.put("\ue016", ":rolling_eyes:");
        EMOJIS.put("\ue017", ":open_mouth:");
        EMOJIS.put("\ue018", ":face_vomiting:");
        EMOJIS.put("\ue019", ":money_mouth:");
        EMOJIS.put("\ue01a", ":smiling_imp:");
        EMOJIS.put("\ue01b", ":nerd:");
        EMOJIS.put("\ue01c", ":poop:");
        EMOJIS.put("\ue01d", ":skull:");
        EMOJIS.put("\ue01e", ":thumbsup:");
        EMOJIS.put("\ue01f", ":thumbsdown:");
        EMOJIS.put("\ue020", ":ok_hand:");
        EMOJIS.put("\ue021", ":eyes:");
        EMOJIS.put("\ue022", ":eggplant:");
        EMOJIS.put("\ue023", ":heart:");
        EMOJIS.put("\ue024", ":orange_heart:");
        EMOJIS.put("\ue025", ":yellow_heart:");
        EMOJIS.put("\ue026", ":green_heart:");
        EMOJIS.put("\ue027", ":blue_heart:");
        EMOJIS.put("\ue028", ":purple_heart:");
        EMOJIS.put("\ue029", ":black_heart:");
        EMOJIS.put("\ue02a", ":broken_heart:");
        EMOJIS.put("\ue02b", ":no_entry:");
        EMOJIS.put("\ue02c", ":100:");
        EMOJIS.put("\ue02d", ":cookie:");
        EMOJIS.put("\ue02e", ":kekw:");
        EMOJIS.put("\ue02f", ":check_mark:");
        EMOJIS.put("\ue030", ":x:");
        EMOJIS.put("\ue031", ":pepe_hands:");
        EMOJIS.put("\ue032", ":diamond:");
        EMOJIS.put("\ue033", ":rainbow_flag:");
        EMOJIS.put("\ue034", ":gg:");
        EMOJIS.put("\ue035", ":woozy_face:");
        EMOJIS.put("\ue036", ":sparkles:");
        EMOJIS.put("\ue037", ":cheese:");
        EMOJIS.put("\ue038", ":whale:");
        EMOJIS.put("\ue039", ":bug:");
        EMOJIS.put("\ue03a", ":hot_face:");
        EMOJIS.put("\ue03b", ":cold_face:");
        EMOJIS.put("\ue03c", ":holding_tears:");
        EMOJIS.put("\ue03d", ":sleeping:");
        EMOJIS.put("\ue03e", ":rocket:");
        EMOJIS.put("\ue03f", ":gun:");
        EMOJIS.put("\ue040", ":melting_face:");
        EMOJIS.put("\ue041", ":angry:");
        EMOJIS.put("\ue042", ":tongue_winking:");
        EMOJIS.put("\ue043", ":thinking:");
        EMOJIS.put("\ue044", ":super_angry:");
        EMOJIS.put("\ue045", ":zipper_mouth:");
        EMOJIS.put("\ue046", ":nauseated_face:");
        EMOJIS.put("\ue047", ":innocent:");
        EMOJIS.put("\ue048", ":cowboy:");
        EMOJIS.put("\ue049", ":shushing_face:");
        EMOJIS.put("\ue04a", ":smiling_tear:");
        EMOJIS.put("\ue04b", ":monocle:");
        EMOJIS.put("\ue04c", ":letter_f:");
        EMOJIS.put("\ue04d", ":arrow_up:");
        EMOJIS.put("\ue04e", ":stinky:");
        EMOJIS.put("\ue04f", ":salute:");
    }
}

