/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.mixins;

import dlovin.castiainvtools.CastiaInvTools;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.StringDecomposer;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatListener.class})
public class ChatMixin {
    @Inject(method={"handleSystemMessage"}, at={@At(value="INVOKE")}, cancellable=true)
    public void onSystemChat(Component message, boolean actionBar, CallbackInfo cb) {
        if (actionBar) {
            return;
        }
        if (!(((Boolean)Minecraft.getInstance().options.hideMatchedNames().get()).booleanValue() && Minecraft.getInstance().isBlocked(this.guessChatUUID(message)) || !CastiaInvTools.getInstance().getClientEvents().handleMessage(message, true))) {
            CastiaInvTools.logger.info("[System] [CANCELED CHAT] {}", (Object)message.getString());
            cb.cancel();
        }
    }

    private UUID guessChatUUID(Component message) {
        String s = StringDecomposer.getPlainText((FormattedText)message);
        String s1 = StringUtils.substringBetween((String)s, (String)"<", (String)">");
        return s1 == null ? Util.NIL_UUID : Minecraft.getInstance().getPlayerSocialManager().getDiscoveredUUID(s1);
    }
}

