/*
 * Decompiled with CFR 0.152.
 */
package dlovin.utils.widgets;

import dlovin.utils.helpers.RenderHelper;
import dlovin.utils.widgets.Widget;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class TextWidget
extends Widget {
    private final int color;
    private final Font fontRenderer;
    private final boolean withTooltip;
    private final ResourceLocation TOOLTIP_ICON = ResourceLocation.tryBuild((String)"guilib", (String)"textures/gui/tt_icon.png");

    public TextWidget(int x, String text, Font fontRenderer) {
        this(x, -1, text, fontRenderer);
    }

    public TextWidget(int x, int color, String text, Font fontRenderer) {
        super(x - 5, 1, fontRenderer.width(text) + 10, 18, text);
        this.x -= this.width - 10;
        this.color = color;
        this.fontRenderer = fontRenderer;
        this.withTooltip = false;
    }

    public TextWidget(int x, String text, Font fontRenderer, Widget.ITooltip tooltip) {
        this(x, -1, text, fontRenderer, tooltip);
    }

    public TextWidget(int x, int color, String text, Font fontRenderer, Widget.ITooltip tooltip) {
        super(x - 5, 1, fontRenderer.width(text) + 10, 18, text, tooltip);
        this.x -= this.width - 10;
        this.color = color;
        this.fontRenderer = fontRenderer;
        this.withTooltip = true;
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float pTick) {
        super.render(gui, mouseX, mouseY, pTick);
        gui.drawString(this.fontRenderer, this.getMessage(), this.x + 5, this.y + 5, this.color);
        if (this.withTooltip) {
            RenderHelper.drawTexture(gui, this.TOOLTIP_ICON, this.x + this.width - 8, this.y, 8, 8);
        }
    }
}

