/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.config;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.config.CITConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class CITConfigManager {
    private static File file;
    private static CITConfig config;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDir().toString(), "castiainvtools.json");
    }

    public static CITConfig initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new CITConfig();
        CITConfigManager.load();
        return config;
    }

    public static void save() {
        CITConfigManager.prepareConfigFile();
        String jsonString = CastiaInvTools.GSON.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save CastiaInvTools configuration file");
            e.printStackTrace();
        }
    }

    private static void load() {
        CITConfigManager.prepareConfigFile();
        try {
            BufferedReader br;
            CITConfig parsed;
            if (!file.exists()) {
                CITConfigManager.save();
            }
            if (file.exists() && (parsed = (CITConfig)CastiaInvTools.GSON.fromJson((Reader)(br = new BufferedReader(new FileReader(file))), CITConfig.class)) != null) {
                config = parsed;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't load InventoryHUD configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static CITConfig getConfig() {
        if (config == null) {
            config = new CITConfig();
        }
        return config;
    }
}

