/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.config;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.config.CITConfig;
import dlovin.castiainvtools.enums.LeftMode;
import dlovin.castiainvtools.enums.SkillMessageType;
import dlovin.castiainvtools.utils.CastiaItemTiers;

public class ConfigValues {
    public int playerVaultsCount;
    public int townVaultsCount;
    public int lastPlayerVault = 1;
    public int lastTownVault = 1;
    public int jobStatsCustomValue = 10;
    public int jobStatsSaveDelay = 0;
    public boolean inventoryButton;
    public boolean craftButton;
    public boolean enderChestButton;
    public boolean playerVaultButton;
    public boolean townVaultButton;
    public boolean trashButton;
    public boolean keepMithrilIconRed;
    public boolean anyTierIcon;
    public boolean emojiButtons;
    public boolean jobStats = true;
    public SkillMessageType skillMessage;
    public LeftMode leftMode;
    public boolean isOnCastia = false;
    public boolean isFindingHomes = false;

    public void init() {
        CITConfig clientConfig = CastiaInvTools.getConfig();
        this.playerVaultsCount = clientConfig.getPvMax();
        this.townVaultsCount = clientConfig.getTvMax();
        this.jobStatsCustomValue = clientConfig.getJobStatsCustomValue();
        this.jobStatsSaveDelay = clientConfig.getJobStatsSaveDelay();
        this.inventoryButton = clientConfig.isInvBtn();
        this.craftButton = clientConfig.isCrBtn();
        this.enderChestButton = clientConfig.isEcBtn();
        this.playerVaultButton = clientConfig.isPvBtn();
        this.townVaultButton = clientConfig.isTvBtn();
        this.trashButton = clientConfig.isTrBtn();
        this.keepMithrilIconRed = clientConfig.isKeepCastians();
        this.emojiButtons = clientConfig.isEmojiButtons();
        this.jobStats = clientConfig.isJobStats();
        this.skillMessage = clientConfig.getSkillMessage();
        this.leftMode = clientConfig.getLeftMode();
        this.initTiers(clientConfig);
        this.resetIcons();
    }

    private void initTiers(CITConfig client) {
        CastiaItemTiers.colorMap.get((Object)"common").enabled = client.isCommonTier();
        CastiaItemTiers.colorMap.get((Object)"rare").enabled = client.isRareTier();
        CastiaItemTiers.colorMap.get((Object)"epic").enabled = client.isEpic();
        CastiaItemTiers.colorMap.get((Object)"legendary").enabled = client.isLegendaryTier();
        CastiaItemTiers.colorMap.get((Object)"begrimed").enabled = client.isBegrimedTier();
        CastiaItemTiers.colorMap.get((Object)"codex").enabled = client.isCodexTier();
        CastiaItemTiers.colorMap.get((Object)"mithril").enabled = client.isMithrilTier();
    }

    public void resetIcons() {
        this.anyTierIcon = CastiaItemTiers.colorMap.values().stream().anyMatch(t -> t.enabled);
    }
}

