/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui;

import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.gui.widgets.EmojiWidget;
import dlovin.castiainvtools.gui.widgets.InventoryButton;
import dlovin.castiainvtools.gui.widgets.PVButton;
import dlovin.castiainvtools.gui.widgets.PageButton;
import dlovin.castiainvtools.references.Identifiers;
import dlovin.castiainvtools.utils.CastiaItemColor;
import dlovin.castiainvtools.utils.CastiaItemTiers;
import dlovin.castiainvtools.utils.ChatUtils;
import dlovin.castiainvtools.utils.ReflectionUtils;
import dlovin.utils.helpers.RenderHelper;
import dlovin.utils.widgets.ButtonWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_490;

public class ToolsGui {
    private final class_310 mc = class_310.method_1551();
    private final String TRASHBIN_TITLE = "Trashbin";
    private final String TOWN_VAULT_TITLE = "Town Vault";
    private final String PLAYER_VAULT_TITLE = "Vault #";
    private final String ENDER_CHEST_TITLE = "Ender Chest";
    private boolean buttonClicked = false;
    private List<ButtonWidget> invButtons = new ArrayList<ButtonWidget>();
    private List<ButtonWidget> pvButtons = new ArrayList<ButtonWidget>();
    private EmojiWidget emojiWidget;
    private final ConfigValues configValues;

    public ToolsGui(ConfigValues configValues) {
        this.configValues = configValues;
        this.configValues.init();
    }

    public void onMouse() {
        if (this.mc.field_1755 instanceof class_465) {
            for (ButtonWidget b : this.invButtons) {
                if (!b.method_25405(0.0, 0.0)) continue;
                this.buttonClicked = true;
                return;
            }
            for (ButtonWidget b : this.pvButtons) {
                if (!b.method_25405(0.0, 0.0)) continue;
                this.buttonClicked = true;
                return;
            }
        } else if (this.mc.field_1755 instanceof class_408 && this.emojiWidget != null) {
            this.emojiWidget.handleClick();
        }
    }

    public void onContainerOpen(int x, int y, int width, int height) {
        class_437 gui = this.mc.field_1755;
        if (gui instanceof class_465) {
            class_465 containerScreen = (class_465)gui;
            this.setupContainerButtons(containerScreen, x, y, width, height);
        }
    }

    public void onChatScreenOpen() {
        class_437 gui = this.mc.field_1755;
        if (gui instanceof class_408 && this.configValues.isOnCastia && this.configValues.emojiButtons) {
            this.emojiWidget = new EmojiWidget();
        }
    }

    private void setupContainerButtons(class_465 gui, int x, int y, int width, int height) {
        boolean leftInv = this.configValues.leftMode.isLeft(gui instanceof class_490);
        int xpos = leftInv ? -23 : x + width;
        int ypos = y + height - 3;
        int pvXRight = x + width;
        int pvXLeft = x;
        int pvYpos = y + 3;
        String title = gui.method_25440().getString();
        int i = 1;
        this.invButtons = new ArrayList<ButtonWidget>();
        if (this.configValues.trashButton && !title.contains("Trashbin")) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", Identifiers.TRASH_ICON, btn -> this.onBTN("trash"), leftInv));
            ++i;
        }
        if (this.configValues.townVaultButton && !title.contains("Town Vault")) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", Identifiers.TOWN_VAULT_ICON, btn -> this.onBTN("t v " + this.configValues.lastTownVault), leftInv));
            ++i;
        }
        if (this.configValues.playerVaultButton && !title.contains("Vault #")) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", Identifiers.PRIVATE_VAULT_ICON, btn -> this.onBTN("pv " + this.configValues.lastPlayerVault), leftInv));
            ++i;
        }
        if (this.configValues.enderChestButton && !title.contains("Ender Chest")) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", Identifiers.ENDER_CHEST_ICON, btn -> this.onBTN("ec"), leftInv));
            ++i;
        }
        if (this.configValues.craftButton && !(gui instanceof class_479)) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", Identifiers.CRAFT_ICON, btn -> this.onBTN("craft"), leftInv));
            ++i;
        }
        if (this.configValues.inventoryButton && !(gui instanceof class_490)) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", Identifiers.INVENTORY_ICON, btn -> this.onBTN(""), leftInv));
        }
        this.createVaultButtons(0, pvXRight, pvXLeft, pvYpos, title);
    }

    private void createVaultButtons(int page, int xpos, int pvXpos, int pvYpos, String title) {
        boolean cpv;
        int pvI;
        int j;
        String commandPrefix;
        int max;
        this.pvButtons = new ArrayList<ButtonWidget>();
        int index = 0;
        if (title.contains("Vault #")) {
            this.configValues.lastPlayerVault = index = Integer.parseInt(title.split("Vault #")[1]);
            max = this.configValues.playerVaultsCount;
            commandPrefix = "pv";
        } else if (title.contains("Town Vault")) {
            max = this.configValues.townVaultsCount;
            commandPrefix = "t v";
        } else {
            return;
        }
        boolean tVault = title.contains("Town Vault");
        int pageMultiplier = page == 0 ? (index - 1) / 10 : page - 1;
        for (j = 0; j < 5 && (pvI = pageMultiplier * 10 + j + 1) <= max; ++j) {
            cpv = pvI == index;
            String command = String.format("%s %d", commandPrefix, pvI);
            this.pvButtons.add(new PVButton(pvXpos - 23, pvYpos + j * 15, cpv ? 26 : 23, 14, "b", cpv, true, pvI, cpv ? btn -> {} : btn -> {
                this.onBTN(command);
                if (tVault) {
                    this.configValues.lastTownVault = pvI;
                }
            }));
        }
        for (j = 0; j < 5 && (pvI = pageMultiplier * 10 + j + 1 + 5) <= max; ++j) {
            cpv = pvI == index;
            int xoff = cpv ? 3 : 0;
            String command = String.format("%s %d", commandPrefix, pvI);
            this.pvButtons.add(new PVButton(xpos - xoff, pvYpos + j * 15, cpv ? 26 : 23, 14, "b", cpv, false, pvI, cpv ? btn -> {} : btn -> {
                this.onBTN(command);
                if (tVault) {
                    this.configValues.lastTownVault = pvI;
                }
            }));
        }
        if (max > (pageMultiplier + 1) * 10) {
            this.pvButtons.add(new PageButton(xpos + 3, pvXpos - 16, 13, 13, "b", false, btn -> this.createVaultButtons(pageMultiplier + 2, xpos, pvXpos, pvYpos, title)));
        }
        if (pageMultiplier > 0) {
            this.pvButtons.add(new PageButton(pvXpos - 16, pvYpos - 16, 13, 13, "b", true, btn -> this.createVaultButtons(pageMultiplier, xpos, pvXpos, pvYpos, title)));
        }
    }

    private void onBTN(String s) {
        this.mc.field_1724.method_7346();
        if (s != "") {
            ChatUtils.sendCommandByLocal(s);
        } else {
            class_304.method_1420((class_3675.class_306)ReflectionUtils.getCastedFieldValue(this.mc.field_1690.field_1822, class_304.class, class_3675.class_306.class, 1));
        }
    }

    private List<Runnable> getCastiaDraws(class_332 context, List<class_1735> slots) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (class_1735 slot : slots) {
            CastiaItemColor tier = CastiaItemTiers.getTierColor(slot.method_7677(), this.configValues.keepMithrilIconRed);
            if (tier == null) continue;
            result.add(() -> RenderHelper.drawTexture(context, tier.icon, slot.field_7873 + tier.x, slot.field_7872 + tier.y, tier.width, tier.height, tier.rawColor));
        }
        return result;
    }

    public void renderEmojiWidget(class_332 context, int mouseX, int mouseY, float pTick) {
        if (this.mc.field_1755 instanceof class_408 && this.configValues.isOnCastia && this.configValues.emojiButtons && this.emojiWidget != null) {
            this.emojiWidget.render(context, mouseX, mouseY, pTick);
        }
    }

    public void renderInside(class_332 context, int mouseX, int mouseY, float pTick) {
        class_437 cs = this.mc.field_1755;
        if (!(cs instanceof class_465)) {
            return;
        }
        this.renderButtons(context, mouseX, mouseY, pTick);
        if (!this.configValues.isOnCastia || !this.configValues.anyTierIcon) {
            return;
        }
        List<Runnable> draws = this.getCastiaDraws(context, (List<class_1735>)((class_465)cs).method_17577().field_7761);
        if (!draws.isEmpty()) {
            context.method_51448().pushMatrix();
            draws.forEach(Runnable::run);
            context.method_51448().popMatrix();
        }
    }

    private void renderButtons(class_332 context, int mouseX, int mouseY, float pTick) {
        ArrayList<Runnable> r = new ArrayList<Runnable>();
        for (ButtonWidget btn : this.invButtons) {
            btn.method_25394(context, mouseX, mouseY, pTick);
            if (!this.buttonClicked) continue;
            r.add(() -> btn.method_25402(mouseX, mouseY, 0));
        }
        for (ButtonWidget btn : this.pvButtons) {
            btn.method_25394(context, mouseX, mouseY, pTick);
            if (!this.buttonClicked) continue;
            r.add(() -> btn.method_25402(mouseX, mouseY, 0));
        }
        r.forEach(Runnable::run);
        this.buttonClicked = false;
    }
}

