/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui.overlays;

import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.gui.overlays.CastiaOverlay;
import dlovin.castiainvtools.utils.CastiaItemColor;
import dlovin.castiainvtools.utils.CastiaItemTiers;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryHUDGui;
import dlovin.inventoryhud.utils.WidgetAligns;
import dlovin.utils.helpers.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_9779;

public class InvHudOverlay
extends CastiaOverlay {
    private class_310 mc;
    private final ConfigValues configValues;

    public InvHudOverlay(ConfigValues configValues) {
        super("inv_hud_castia_tier_icons");
        this.configValues = configValues;
    }

    private List<Runnable> getCastiaDraws(class_332 context, int iMax, int jMax) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = InventoryHUD.getInstance().getInvhudGUI().invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                CastiaItemColor tier = CastiaItemTiers.getTierColor(this.mc.field_1724.method_31548().method_5438(index), this.configValues.keepMithrilIconRed);
                if (tier == null) continue;
                int finalI = i;
                int finalJ = j;
                result.add(() -> RenderHelper.drawTexture(context, tier.icon, finalI * 18 + tier.x, finalJ * 18 + tier.y, tier.width, tier.height, tier.rawColor));
            }
        }
        return result;
    }

    @Override
    public void render(class_332 context, class_9779 ticker) {
        int jMax;
        if (!this.checkConditions()) {
            return;
        }
        int iMax = this.invHud().invVert ? 3 : 9;
        List<Runnable> draws = this.getCastiaDraws(context, iMax, jMax = this.invHud().invVert ? 9 : 3);
        if (draws.isEmpty()) {
            return;
        }
        int width = this.mc.method_22683().method_4486();
        int height = this.mc.method_22683().method_4502();
        float scale = this.invHud().invMini ? 0.75f : 1.0f;
        int px = switch (this.invHud().InvAligns.HorAlign) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.HAlign.LEFT -> this.invHud().invX;
            case WidgetAligns.HAlign.MIDDLE -> (int)((float)(width / 2) - (float)(iMax * 9) * scale - (float)this.invHud().invX);
            case WidgetAligns.HAlign.RIGHT -> width - this.invHud().invX;
        };
        int py = switch (this.invHud().InvAligns.VertAlign) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.VAlign.TOP -> this.invHud().invY;
            case WidgetAligns.VAlign.CENTER -> (int)((float)(height / 2) - (float)(jMax * 9) * scale - (float)this.invHud().invY);
            case WidgetAligns.VAlign.BOTTOM -> height - this.invHud().invY;
        };
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)px, (float)py);
        context.method_51448().scale(scale, scale);
        draws.forEach(Runnable::run);
        context.method_51448().popMatrix();
    }

    private boolean checkConditions() {
        return this.configValues.isOnCastia && this.configValues.anyTierIcon && !(this.mc.field_1755 instanceof class_465) && InventoryHUD.InvHUD;
    }

    @Override
    public void init() {
        this.mc = class_310.method_1551();
    }

    private InventoryHUDGui invHud() {
        return InventoryHUD.getInstance().getInvhudGUI();
    }
}

