/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui.screens;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.enums.LeftMode;
import dlovin.castiainvtools.enums.SkillMessageType;
import dlovin.castiainvtools.gui.screens.ChildScreenWithList;
import dlovin.castiainvtools.gui.screens.SoundConfigScreen;
import dlovin.castiainvtools.gui.screens.TierConfigGui;
import dlovin.utils.widgets.CheckBox;
import dlovin.utils.widgets.CustomButton;
import dlovin.utils.widgets.NumericTextField;
import dlovin.utils.widgets.TextField;
import dlovin.utils.widgets.TextWidget;
import dlovin.utils.widgets.Widget;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class CITConfigScreen
extends ChildScreenWithList {
    private ConfigValues configValues = CastiaInvTools.configValues();

    public CITConfigScreen(class_437 parent, class_2561 title) {
        super(title, parent);
    }

    @Override
    public void addOptions() {
        int posX = this.field_22789 / 2;
        int i = 0;
        this.optionList.addWidget(new TextWidget(posX, "Toggle on/off inventory buttons:", this.field_22793), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Inventory:", this.field_22793), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onInventory, this.configValues.inventoryButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Craft:", this.field_22793), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onCraft, this.configValues.craftButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Ender chest:", this.field_22793), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onEnder, this.configValues.enderChestButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Player Vault:", this.field_22793), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onPV, this.configValues.playerVaultButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Town Vault:", this.field_22793), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onTV, this.configValues.townVaultButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Trash:", this.field_22793), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onTrash, this.configValues.trashButton), i++);
        this.optionList.addWidget(new TextWidget(posX, "Skill Earnings Options:", this.field_22793), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Track skill earnings:", this.field_22793), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onJobStats, this.configValues.jobStats), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Skill Earnings last minutes:", this.field_22793), i);
        this.optionList.addWidget(new NumericTextField(this.field_22793, posX + 10, 0, 40, 20, 1, 30, this.configValues.jobStatsCustomValue, this::onJobValue), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Skill Earnings save delay:", this.field_22793), i);
        this.optionList.addWidget(new NumericTextField(this.field_22793, posX + 10, 0, 40, 20, 0, 10, this.configValues.jobStatsSaveDelay, this::onJobSave), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Skill income messages:", this.field_22793), i);
        CustomButton sbtn = new CustomButton(posX + 10, 0, 90, 18, this.configValues.skillMessage.humanize(), null, false);
        sbtn.addListener(this::onSkillMessage);
        this.optionList.addWidget(sbtn, i++);
        this.optionList.addWidget(new TextWidget(posX, "Other Options:", this.field_22793), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Tier Icons Menu:", this.field_22793), i);
        CustomButton tbtn = new CustomButton(posX + 10, 0, 50, 18, "Open", null, false);
        tbtn.addListener(this::onTierMenu);
        this.optionList.addWidget(tbtn, i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Castia Sounds Menu:", this.field_22793), i);
        CustomButton sound = new CustomButton(posX + 10, 0, 50, 18, "Sound", null, false);
        sound.addListener(btn -> class_310.method_1551().method_1507((class_437)new SoundConfigScreen(this)));
        this.optionList.addWidget(sound, i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Left side mode:", this.field_22793), i);
        CustomButton cbtn = new CustomButton(posX + 10, 0, 90, 18, this.configValues.leftMode.toString(), null, false);
        cbtn.addListener(this::onLeftMode);
        this.optionList.addWidget(cbtn, i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Emoji Buttons:", this.field_22793), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onEmojiButtons, this.configValues.emojiButtons), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Private Vault Max Count:", this.field_22793), i);
        this.optionList.addWidget(new NumericTextField(this.field_22793, posX + 10, 0, 40, 20, 1, 50, this.configValues.playerVaultsCount, this::onPvChanged), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Town Vault Max Count:", this.field_22793), i);
        this.optionList.addWidget(new NumericTextField(this.field_22793, posX + 10, 0, 40, 20, 1, 50, this.configValues.townVaultsCount, this::onTvChanged), i++);
    }

    private void onSkillMessage(Widget btn) {
        SkillMessageType type = CastiaInvTools.getConfig().getSkillMessage().next();
        CastiaInvTools.getConfig().setSkillMessage(type);
        this.configValues.skillMessage = type;
        btn.setMessage(type.humanize());
        CastiaInvTools.save();
    }

    private void onJobSave(TextField btn) {
        try {
            int value = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().setJobStatsSaveDelay(value);
            this.configValues.jobStatsSaveDelay = value;
            CastiaInvTools.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onJobValue(TextField btn) {
        try {
            int value = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().setJobStatsCustomValue(value);
            this.configValues.jobStatsCustomValue = value;
            CastiaInvTools.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onJobStats(CheckBox box) {
        CastiaInvTools.getConfig().setJobStats(box.checked);
        this.configValues.jobStats = box.checked;
        CastiaInvTools.save();
    }

    private void onEmojiButtons(CheckBox box) {
        CastiaInvTools.getConfig().setEmojiButtons(box.checked);
        this.configValues.emojiButtons = box.checked;
        CastiaInvTools.save();
    }

    private void onTierMenu(Widget widget) {
        class_310.method_1551().method_1507((class_437)new TierConfigGui(this));
    }

    private void onLeftMode(Widget btn) {
        LeftMode mode = CastiaInvTools.getConfig().getLeftMode().next();
        CastiaInvTools.getConfig().setLeftMode(mode);
        this.configValues.leftMode = mode;
        btn.setMessage(mode.toString());
        CastiaInvTools.save();
    }

    private void onPvChanged(TextField btn) {
        try {
            int x = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().setPvMax(x);
            CastiaInvTools.save();
            this.configValues.playerVaultsCount = x;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onTvChanged(TextField btn) {
        try {
            int x = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().setTvMax(x);
            this.configValues.townVaultsCount = x;
            CastiaInvTools.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onTrash(CheckBox btn) {
        CastiaInvTools.getConfig().setTrBtn(btn.checked);
        this.configValues.trashButton = btn.checked;
        CastiaInvTools.save();
    }

    private void onTV(CheckBox btn) {
        CastiaInvTools.getConfig().setTvBtn(btn.checked);
        this.configValues.townVaultButton = btn.checked;
        CastiaInvTools.save();
    }

    private void onPV(CheckBox btn) {
        CastiaInvTools.getConfig().setPvBtn(btn.checked);
        this.configValues.playerVaultButton = btn.checked;
        CastiaInvTools.save();
    }

    private void onEnder(CheckBox btn) {
        CastiaInvTools.getConfig().setEcBtn(btn.checked);
        this.configValues.enderChestButton = btn.checked;
        CastiaInvTools.save();
    }

    private void onCraft(CheckBox btn) {
        CastiaInvTools.getConfig().setCrBtn(btn.checked);
        this.configValues.craftButton = btn.checked;
        CastiaInvTools.save();
    }

    private void onInventory(CheckBox btn) {
        CastiaInvTools.getConfig().setInvBtn(btn.checked);
        this.configValues.inventoryButton = btn.checked;
        CastiaInvTools.save();
    }
}

