/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui.screens;

import dlovin.castiainvtools.gui.screens.ScreenWithList;
import dlovin.castiainvtools.utils.ChatUtils;
import dlovin.utils.widgets.ButtonWidget;
import dlovin.utils.widgets.CustomButton;
import dlovin.utils.widgets.CustomOptionList;
import dlovin.utils.widgets.TextField;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class HomesGui
extends ScreenWithList {
    private TextField searchField;
    private String filter = "";
    private final String[] homes;
    private int maxwidth;

    public HomesGui(String[] homes) {
        super((class_2561)class_2561.method_43470((String)"Homes"));
        this.homes = (String[])Stream.of(homes).sorted().toArray(String[]::new);
        class_327 f = class_310.method_1551().field_1772;
        for (String s : homes) {
            if (f.method_1727(s) <= this.maxwidth) continue;
            this.maxwidth = f.method_1727(s);
        }
        this.maxwidth += 20;
    }

    protected void method_25426() {
        this.optionList = new CustomOptionList(this.field_22787, this, 32, 30);
        this.initHomes();
        this.searchField = new TextField(this.field_22793, this.field_22789 / 2 - this.maxwidth / 2, this.field_22790 - 25, this.maxwidth, 20, "", this::filterChanged);
        this.searchField.setMaxStringLength(255);
        this.searchField.setOnSubmit(this::handleSearchSubmit);
        this.method_25396().add(this.optionList);
        this.method_25396().add(this.searchField);
        this.method_25402(this.searchField.x + 1, this.searchField.y + 1, 0);
    }

    private void initHomes() {
        int index = 0;
        for (String home : this.homes) {
            if (!this.filter.isEmpty() && !home.toLowerCase().contains(this.filter.toLowerCase())) continue;
            this.addButton(home, index);
            ++index;
        }
    }

    private void addButton(String home, int index) {
        CustomButton tmp = new CustomButton(this.field_22789 / 2 - this.maxwidth / 2, 0, this.maxwidth, 20, home, null, false);
        this.optionList.addWidget(tmp, index);
        tmp.addListener(this::handleHomeClick);
    }

    private void filterChanged(TextField field) {
        this.filter = field.getText().toLowerCase();
        this.optionList.clear();
        this.initHomes();
    }

    @Override
    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float partialTick) {
        super.method_25394(context, mouseX, mouseY, partialTick);
        this.searchField.method_25394(context, mouseX, mouseY, partialTick);
    }

    private void handleHomeClick(ButtonWidget btn) {
        this.teleportToHome(btn.getMessage());
    }

    private void handleSearchSubmit(TextField _field) {
        if (this.optionList.getWidgets().isEmpty()) {
            return;
        }
        this.teleportToHome(this.optionList.getWidgets().getFirst().getMessage());
    }

    private void teleportToHome(String home) {
        ChatUtils.sendCommandByLocal(String.format(Locale.ROOT, "h %s", home));
        this.field_22787.method_1507(null);
    }
}

