/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.utils.jobs;

import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.utils.JsonUtils;
import dlovin.castiainvtools.utils.jobs.Income;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobEarnings {
    private static JobEarnings instance;
    private final ConfigValues configValues;
    final Pattern PATTERN = Pattern.compile("\ue08a You received \\$([0-9.]+) and [0-9.]+xp");
    final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    final DateTimeFormatter MONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM");
    final SimpleDateFormat SIMPLE_DAY_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    List<Income> lastHourIncome = new ArrayList<Income>();
    Map<String, Double> dailyIncome;
    Map<String, Double> monthlyIncome;
    private double lastHourAmount = 0.0;
    private double lastHourAverage = 0.0;
    private double lastMinutesAmount = 0.0;
    private double lastMinutesAverage = 0.0;
    private double sessionIncome = 0.0;
    private double overallIncome;
    private double lastWeekIncome = 0.0;
    private long lastSaveTime = 0L;

    public JobEarnings(ConfigValues configValues) {
        this.configValues = configValues;
        JsonUtils.loadValues(this);
    }

    public static JobEarnings initialize(ConfigValues configValues) {
        instance = new JobEarnings(configValues);
        return instance;
    }

    public static JobEarnings getInstance() {
        return instance;
    }

    public boolean handleMessage(String message) {
        Matcher matcher = this.PATTERN.matcher(message);
        if (matcher.find()) {
            this.addIncome(Double.parseDouble(matcher.group(1)));
            return true;
        }
        return false;
    }

    public void save() {
        JsonUtils.saveValues(this);
    }

    public void setDailyIncome(Map<String, Double> map) {
        this.dailyIncome = map;
    }

    public void setMonthlyIncome(Map<String, Double> map) {
        this.monthlyIncome = map;
    }

    public void setOverallValue(double amount) {
        this.overallIncome = amount;
    }

    public Map<String, Double> getDailyIncome() {
        return this.dailyIncome;
    }

    public Map<String, Double> getMonthlyIncome() {
        return this.monthlyIncome;
    }

    public double getOverallIncome() {
        return this.overallIncome;
    }

    public Object[] getStats() {
        long time = System.currentTimeMillis();
        this.calculateIncome(time);
        return new Object[]{new Object[]{"Overall income", this.overallIncome}, new Object[]{"Session income", this.sessionIncome}, new Object[]{"Last hour income", this.lastHourAmount}, new Object[]{"Average in last hour", this.lastHourAverage}, new Object[]{String.format("Last %d minutes income", this.configValues.jobStatsCustomValue), this.lastMinutesAmount}, new Object[]{String.format("Average in %d minutes", this.configValues.jobStatsCustomValue), this.lastMinutesAverage}, new Object[]{"This month income", this.monthlyIncome.getOrDefault(this.month(time), 0.0)}, new Object[]{"Last 7 days income", this.lastWeekIncome}, new Object[]{"Today's income", this.dailyIncome.getOrDefault(this.today(time), 0.0)}};
    }

    private void addIncome(double amount) {
        long currentTime = System.currentTimeMillis();
        this.lastHourIncome.add(new Income(amount, currentTime));
        this.sessionIncome += amount;
        this.overallIncome += amount;
        this.lastHourIncome.removeIf(i -> currentTime - i.time > 3600000L);
        this.dailyIncome.merge(this.today(currentTime), amount, Double::sum);
        this.monthlyIncome.merge(this.month(currentTime), amount, Double::sum);
        if (currentTime - this.lastSaveTime > (long)this.configValues.jobStatsSaveDelay * 60000L) {
            this.save();
            this.lastSaveTime = currentTime;
        }
    }

    private void calculateIncome(long currentTime) {
        this.lastHourIncome.removeIf(i -> currentTime - i.time > 3600000L);
        this.lastHourAmount = this.lastHourIncome.stream().mapToDouble(i -> i.value).sum();
        this.lastHourAverage = this.lastHourAmount / (double)this.lastHourIncome.size();
        long minutesMillis = 60000L * (long)this.configValues.jobStatsCustomValue;
        double[] lastMinutes = this.lastHourIncome.stream().filter(i -> currentTime - i.time <= minutesMillis).mapToDouble(i -> i.value).toArray();
        this.lastMinutesAmount = Arrays.stream(lastMinutes).sum();
        this.lastMinutesAverage = this.lastMinutesAmount / (double)lastMinutes.length;
        this.lastWeekIncome = 0.0;
        Calendar now = Calendar.getInstance();
        for (int i2 = 0; i2 < 7; ++i2) {
            this.lastWeekIncome += this.dailyIncome.getOrDefault(this.SIMPLE_DAY_FORMATTER.format(now.getTime()), 0.0).doubleValue();
            now.add(5, -1);
        }
    }

    private String today(long time) {
        return this.DAY_FORMATTER.format(Instant.ofEpochMilli(time).atZone(ZoneId.systemDefault()).toLocalDate());
    }

    private String month(long time) {
        return this.MONTH_FORMATTER.format(Instant.ofEpochMilli(time).atZone(ZoneId.systemDefault()).toLocalDate());
    }
}

