/*
 * Decompiled with CFR 0.152.
 */
package dlovin.utils.widgets;

import dlovin.utils.helpers.RenderHelper;
import dlovin.utils.widgets.RowOfWidgets;
import dlovin.utils.widgets.TextField;
import dlovin.utils.widgets.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class CustomOptionList
extends class_350 {
    private static final int ITEM_HEIGHT = 30;
    private final List<RowOfWidgets> rows = new ArrayList<RowOfWidgets>();
    private int maxHeight;
    private int scroll = 0;
    private double tmp_scroll = 0.0;
    private boolean isDragging = false;
    private final class_2960 SCROLL_BG = class_2960.method_43902((String)"guilib", (String)"textures/gui/scroll.png");

    public CustomOptionList(class_310 minecraft, class_437 screen) {
        this(minecraft, screen, 55);
    }

    public CustomOptionList(class_310 minecraft, class_437 screen, int top) {
        this(minecraft, screen, top, 0);
    }

    public CustomOptionList(class_310 minecraft, class_437 screen, int top, int bottom) {
        super(minecraft, screen.field_22789, screen.field_22790 - top - bottom, top, 30);
    }

    public void addWidget(Widget widget, int row) {
        if (this.maxHeight < (row + 1) * 30 + 10) {
            this.maxHeight = (row + 1) * 30 + 10;
        }
        widget.y = this.method_46427() + 10 + 30 * row + widget.y - this.scroll;
        if (this.rows.stream().anyMatch(r -> r.index == row)) {
            this.rows.stream().filter(r -> r.index == row).findFirst().ifPresent(r -> r.addWidget(widget));
        } else {
            this.rows.add(new RowOfWidgets(row, widget));
        }
    }

    public void insertWidget(Widget widget, int row) {
        int lastRowIndex = 0;
        for (RowOfWidgets r2 : this.rows) {
            if (r2.index <= lastRowIndex) continue;
            lastRowIndex = r2.index;
        }
        this.maxHeight = (lastRowIndex + 2) * 30 + 10;
        widget.y = this.method_46427() + 10 + 30 * row + widget.y - this.scroll;
        this.rows.stream().filter(r -> r.index >= row).forEach(r -> {
            ++r.index;
            for (Widget w : r.widgetList) {
                w.y += 30;
            }
        });
        this.rows.add(new RowOfWidgets(row, widget));
    }

    public void clear() {
        Iterator<RowOfWidgets> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.maxHeight = 0;
        this.scroll = 0;
        this.tmp_scroll = 0.0;
    }

    public void removeRowWith(Widget widget) {
        int index = 0;
        for (RowOfWidgets row : this.rows) {
            if (!row.widgetList.contains(widget)) continue;
            index = row.index;
            break;
        }
        this.removeRow(index);
    }

    public void removeRow(int index) {
        boolean removed = false;
        Iterator<RowOfWidgets> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            RowOfWidgets item = iterator.next();
            if (item.index != index) continue;
            iterator.remove();
            removed = true;
            break;
        }
        if (!removed) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            if (row.index <= index) continue;
            --row.index;
            for (Widget w : row.widgetList) {
                w.y -= 30;
            }
        }
        this.maxHeight -= 30;
        int diff = this.maxHeight - (this.method_55443() - this.method_46427());
        if (diff < 0) {
            double tmp = this.scroll;
            this.scroll = 0;
            this.adjustWidgetsPos(tmp);
        } else {
            this.method_25401(0.0, 0.0, 0.0, 0.0);
        }
    }

    public List<Widget> getWidgets() {
        ArrayList<Widget> tmp = new ArrayList<Widget>();
        for (RowOfWidgets row : this.rows) {
            tmp.addAll(row.widgetList);
        }
        return tmp;
    }

    public int rowsCount() {
        return this.rows.size();
    }

    private double scroll(double amount) {
        double tmp = (int)(amount * 5.0);
        int diff = this.maxHeight - (this.method_55443() - this.method_46427());
        this.scroll -= (int)tmp;
        if (this.scroll < 0) {
            tmp += (double)this.scroll;
            this.scroll = 0;
        } else if (this.scroll > diff) {
            tmp += (double)(this.scroll - diff);
            this.scroll = diff;
        }
        return tmp;
    }

    private void adjustWidgetsPos(double amount) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (w instanceof TextField && w.method_25370()) {
                    ((TextField)w).setFocused2(false);
                }
                w.y += (int)amount;
            }
        }
    }

    public boolean method_25401(double mx, double my, double scrollX, double scrollY) {
        if (this.maxHeight > this.method_55443() - this.method_46427()) {
            this.adjustWidgetsPos(this.scroll(scrollY));
        }
        return true;
    }

    public boolean method_25403(double mx, double my, int button, double dragX, double dragY) {
        this.rows.forEach(r -> r.widgetList.forEach(w -> w.method_25403(mx, my, button, dragX, dragY)));
        if (this.isDragging) {
            int height = this.method_55443() - this.method_46427();
            double scale = (double)height / (double)this.maxHeight;
            this.tmp_scroll += dragY / scale;
            int tmp = (int)this.tmp_scroll;
            this.tmp_scroll -= (double)tmp;
            int diff = this.maxHeight - (this.method_55443() - this.method_46427());
            this.scroll += tmp;
            if (this.scroll < 0) {
                tmp -= this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp -= this.scroll - diff;
                this.scroll = diff;
            }
            this.adjustWidgetsPos(-tmp);
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseBtn) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (this.maxHeight > this.method_55443() - this.method_46427() && mouseBtn == 0) {
            int pos = this.field_22758 > 309 ? this.field_22758 / 2 + 150 : this.field_22758 - 9;
            int height = this.method_55443() - this.method_46427();
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.method_46427() + (int)((double)this.scroll * scale);
            if (this.isOver(mouseX, mouseY, pos + 1, pos + 8, yPos + 1, yPos + height - 1)) {
                this.isDragging = true;
            }
        }
        ArrayList<Runnable> clicks = new ArrayList<Runnable>();
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!w.hovered && !(w instanceof TextField)) continue;
                clicks.add(() -> w.method_25402(mouseX, mouseY, mouseBtn));
            }
        }
        clicks.forEach(Runnable::run);
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseBtn) {
        this.isDragging = false;
        this.rows.forEach(r -> r.widgetList.forEach(w -> w.method_25406(mouseX, mouseY, mouseBtn)));
        return false;
    }

    public boolean method_25400(char character, int keyCode) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof TextField) || !w.method_25370()) continue;
                w.method_25400(character, keyCode);
                return true;
            }
        }
        return false;
    }

    public boolean method_25404(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof TextField) || !w.method_25370()) continue;
                w.method_25404(p_231046_1_, p_231046_2_, p_231046_3_);
                return true;
            }
        }
        super.method_25404(p_231046_1_, p_231046_2_, p_231046_3_);
        return false;
    }

    private void renderScrollBG(class_332 gui, int xPos, int height) {
        RenderHelper.drawTextureWithBorder(gui, this.SCROLL_BG, xPos, this.method_46427(), 9, height, 3, 16, 32);
    }

    private void renderScroll(class_332 gui, int xPos, int height, int pos, int color) {
        RenderHelper.drawTextureWithBorder(gui, this.SCROLL_BG, xPos, pos, 9, Math.max(height, 6), 16, 0, 3, 16, 32, color);
    }

    private boolean isOver(double p_231047_1_, double p_231047_3_, int min_x, int max_x, int min_y, int max_y) {
        return p_231047_3_ >= (double)min_y && p_231047_3_ <= (double)max_y && p_231047_1_ >= (double)min_x && p_231047_1_ <= (double)max_x;
    }

    protected void method_25311(@NotNull class_332 gui, int mx, int my, float pt) {
        if (this.maxHeight > this.method_55443() - this.method_46427()) {
            int pos = this.field_22758 > 309 ? this.field_22758 / 2 + 150 : this.field_22758 - 9;
            int height = this.method_55443() - this.method_46427();
            this.renderScrollBG(gui, pos, height);
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.method_46427() + (int)((double)this.scroll * scale);
            int color = class_9848.method_61324((int)255, (int)204, (int)204, (int)204);
            if (this.isOver(mx, my, pos + 1, pos + 8, yPos + 1, yPos + height - 1) && this.isDragging) {
                color = -1;
            }
            this.renderScroll(gui, pos, height, yPos, color);
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.method_25394(gui, mx, my, pt);
            }
        }
    }

    public void renderTooltips(class_332 gui, int x, int y) {
        if (y > this.method_55443() || y < this.method_46427() || x > this.field_22758 || x < this.method_46426()) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.renderTooltip(gui, x, y);
            }
        }
    }

    protected void method_47399(class_6382 builder) {
    }
}

