/*
 * Decompiled with CFR 0.152.
 */
package dlovin.utils.widgets;

import dlovin.utils.widgets.ButtonWidget;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8015;
import net.minecraft.class_8494;

public class SliderWidget
extends ButtonWidget {
    private static final class_2960 SLIDER_SPRITE = class_2960.method_60656((String)"widget/slider");
    private static final class_2960 HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_highlighted");
    private static final class_2960 SLIDER_HANDLE_SPRITE = class_2960.method_60656((String)"widget/slider_handle");
    private static final class_2960 SLIDER_HANDLE_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_handle_highlighted");
    protected double value;
    private boolean canChangeValue;
    private String name;
    private int isDragging = -1;

    public SliderWidget(int x, int y, int width, int height, String message, double value, ButtonWidget.ButtonClickListener onApply) {
        super(x, y, width, height, message);
        this.name = message;
        this.value = value;
        this.listeners.add(onApply);
        this.updateMessage();
    }

    public double getValue() {
        return this.value;
    }

    protected class_2960 getSprite() {
        return this.method_25370() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    protected class_2960 getHandleSprite() {
        return !this.hovered && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    @Override
    public void method_25394(class_332 gui, int mx, int my, float pTick) {
        super.method_25394(gui, mx, my, pTick);
        class_310 minecraft = class_310.method_1551();
        gui.method_52707(class_10799.field_56883, this.getSprite(), this.x, this.y, this.width, this.height, -1);
        gui.method_52707(class_10799.field_56883, this.getHandleSprite(), this.x + (int)(this.value * (double)(this.width - 8)), this.y, 8, this.height, -1);
        gui.method_25300(minecraft.field_1772, this.getMessage(), this.x + this.width / 2, this.y + this.height / 2 - 4, -1);
    }

    @Override
    public boolean method_25402(double mx, double my, int button) {
        if (!this.hovered) {
            return false;
        }
        this.isDragging = button;
        this.setValueFromMouse(mx);
        return true;
    }

    @Override
    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.canChangeValue = false;
        } else {
            class_8015 guiNavigationType = class_310.method_1551().method_48186();
            if (guiNavigationType == class_8015.field_41778 || guiNavigationType == class_8015.field_41780) {
                this.canChangeValue = true;
            }
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_8494.method_51255((int)keyCode)) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean flag;
            boolean bl = flag = keyCode == 263;
            if (flag || keyCode == 262) {
                float f = flag ? -1.0f : 1.0f;
                this.setValue(this.value + (double)(f / (float)(this.width - 8)));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mx) {
        this.setValue((mx - (double)(this.x + 4)) / (double)(this.width - 8));
    }

    private void setValue(double value) {
        double d0 = this.value;
        this.value = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        if (d0 != this.value) {
            this.listeners.forEach(l -> l.onClick(this));
        }
        this.updateMessage();
    }

    @Override
    public boolean method_25403(double mx, double my, int mb, double deltaX, double deltaY) {
        if (this.isDragging != mb) {
            return false;
        }
        this.setValueFromMouse(mx);
        return true;
    }

    @Override
    public boolean method_25406(double mx, double my, int button) {
        if (this.isDragging == button) {
            this.isDragging = -1;
            super.playDownSound(class_310.method_1551().method_1483());
        }
        return this.hovered;
    }

    protected void updateMessage() {
        this.setMessage(this.name + ": " + (int)(this.value * 100.0) + "%");
    }
}

