/*
 * Decompiled with CFR 0.152.
 */
package dlovin.utils.widgets;

import dlovin.utils.helpers.RenderHelper;
import dlovin.utils.widgets.Widget;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_10799;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_9848;

public class TextField
extends Widget {
    private static int DEFAULT_TEXT_COLOR = class_9848.method_61330((int)255, (int)0xE0E0E0);
    protected final IPressable onChange;
    protected Submittable onSubmit;
    private final class_327 fontRenderer;
    protected String text;
    protected int maxStringLength = 255;
    protected boolean isFocused;
    protected boolean isShiftDown;
    private int lineScrollOffset;
    protected int cursorPosition;
    protected int selectionEnd;
    protected String prevText;
    private final class_2960 BG = class_2960.method_43902((String)"guilib", (String)"textures/gui/tf_bg.png");
    protected Predicate<String> validator = Objects::nonNull;
    private final BiFunction<String, Integer, class_5481> textFormatter = (string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);

    @Deprecated
    public TextField(class_327 font, int x, int y, int width, int height, String text) {
        this(font, x, y, width, height, text, p -> {});
    }

    public TextField(class_327 font, int x, int y, int width, int height, String text, IPressable onChange) {
        this(font, x, y, width, height, text, onChange, null);
    }

    public TextField(class_327 font, int x, int y, int width, int height, String text, IPressable onChange, String regex) {
        super(x, y, width, height, text);
        this.text = this.prevText = text;
        this.fontRenderer = font;
        this.onChange = onChange;
        if (regex != null) {
            this.validator = s -> Pattern.matches(regex, s);
        }
    }

    public void setOnSubmit(Submittable onSubmit) {
        this.onSubmit = onSubmit;
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void writeText(String textToWrite) {
        String s1;
        String s;
        int l;
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (k < (l = (s = textToWrite).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.validator.test(s1 = new StringBuilder(this.text).replace(i, j, s).toString())) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        if (!newText.equals(this.prevText)) {
            this.prevText = newText;
            this.onChange.onChanged(this);
        }
    }

    protected void delete(int p_212950_1_) {
        if (class_437.method_25441()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.offsetByCodepoints(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPosWS(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPosWS(int n, int pos) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.offsetByCodepoints(num));
    }

    private int offsetByCodepoints(int num) {
        return this.offsetByCodepoints(this.text, this.cursorPosition, num);
    }

    private int offsetByCodepoints(String text, int cursorPosition, int num) {
        int i = text.length();
        if (num >= 0) {
            for (int j = 0; cursorPosition < i && j < num; ++j) {
                if (!Character.isHighSurrogate(text.charAt(cursorPosition++)) || cursorPosition >= i || !Character.isLowSurrogate(text.charAt(cursorPosition))) continue;
                ++cursorPosition;
            }
        } else {
            for (int k = num; cursorPosition > 0 && k < 0; ++k) {
                if (!Character.isLowSurrogate(text.charAt(--cursorPosition)) || cursorPosition <= 0 || !Character.isHighSurrogate(text.charAt(cursorPosition - 1))) continue;
                --cursorPosition;
            }
        }
        return cursorPosition;
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.isShiftDown) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.onTextChanged(this.text);
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = this.clamp0(pos, this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean method_25404(int keyCode, int p_231046_2_, int p_231046_3_) {
        if (!this.canWrite()) {
            return false;
        }
        this.isShiftDown = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.writeText(class_310.method_1551().field_1774.method_1460());
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                if (this.onSubmit != null) {
                    this.onSubmit.onSubmit(this);
                    return true;
                }
            }
            case 256: {
                this.setFocused2(false);
                return true;
            }
            case 259: {
                this.isShiftDown = false;
                this.delete(-1);
                this.isShiftDown = class_437.method_25442();
                return true;
            }
            case 260: 
            case 261: 
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                this.isShiftDown = false;
                this.delete(1);
                this.isShiftDown = class_437.method_25442();
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: {
                this.setCursorPositionEnd();
                return true;
            }
        }
        return false;
    }

    public boolean canWrite() {
        return this.getVisible() && this.method_25370() && this.isEnabled();
    }

    @Override
    public boolean method_25370() {
        return this.isFocused;
    }

    @Override
    public boolean method_25400(char character, int _ignored) {
        if (!this.canWrite()) {
            return false;
        }
        this.writeText(Character.toString(character));
        return true;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int action) {
        if (!this.getVisible()) {
            return false;
        }
        boolean flag = mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        this.setFocused2(flag);
        if (this.method_25370() && flag && action == 0) {
            int i = this.floor(mouseX) - this.x - 4;
            String s = this.fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            this.setCursorPosition(this.fontRenderer.method_27523(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public void setFocused2(boolean isFocusedIn) {
        this.isFocused = isFocusedIn;
        if (!isFocusedIn) {
            this.isShiftDown = false;
            this.setCursorPosition(0);
        }
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float pTick) {
        super.method_25394(gui, mouseX, mouseY, pTick);
        if (this.getVisible()) {
            if (this.method_25370()) {
                this.renderBtnBg(gui, 0, 16);
            } else if (this.hovered) {
                this.renderBtnBg(gui, 16, 0);
            } else {
                this.renderBtnBg(gui, 0, 0);
            }
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            String s = this.fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.method_25370() && flag;
            int l = this.x + 4;
            int i1 = this.y + (this.height - 8) / 2;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                class_5481 formattedcharsequence = this.textFormatter.apply(s1, this.lineScrollOffset);
                gui.method_35720(this.fontRenderer, formattedcharsequence, l, i1, DEFAULT_TEXT_COLOR);
                j1 += this.fontRenderer.method_30880(formattedcharsequence) + 1;
            }
            boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                gui.method_35720(this.fontRenderer, this.textFormatter.apply(s.substring(j), this.cursorPosition), j1, i1, DEFAULT_TEXT_COLOR);
            }
            if (flag1) {
                if (flag2) {
                    gui.method_25294(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    gui.method_25303(this.fontRenderer, "_", k1, i1, DEFAULT_TEXT_COLOR);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.method_1727(s.substring(0, k));
                this.drawSelectionBox(gui, k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    private void drawSelectionBox(class_332 gui, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        gui.method_48196(class_10799.field_56881, startX, startY, endX, endY, -16776961);
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    private boolean getEnableBackgroundDrawing() {
        return true;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    private boolean isEnabled() {
        return true;
    }

    public int getAdjustedWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        this.selectionEnd = this.clamp0(position, i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = this.clamp0(this.lineScrollOffset, i);
        }
    }

    public boolean getVisible() {
        return true;
    }

    public void setX(int xIn) {
        this.x = xIn;
    }

    private void renderBtnBg(class_332 gui, int offsetX, int offsetY) {
        RenderHelper.drawTextureWithBorder(gui, this.BG, this.x, this.y, this.width, this.height, offsetX, offsetY, 2, 16, 32);
    }

    public static interface IPressable {
        public void onChanged(TextField var1);
    }

    public static interface Submittable {
        public void onSubmit(TextField var1);
    }
}

