/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools;

import com.mojang.logging.LogUtils;
import dlovin.castiainvtools.config.CastiaInvToolsConfigScreenHandler;
import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.config.THLConfig;
import dlovin.castiainvtools.events.ClientEvents;
import dlovin.castiainvtools.events.KeyEvents;
import dlovin.castiainvtools.gui.ToolsGui;
import dlovin.castiainvtools.gui.overlays.CastiaOverlay;
import dlovin.castiainvtools.gui.overlays.IconsOverlay;
import dlovin.castiainvtools.gui.overlays.InvHudOverlay;
import dlovin.castiainvtools.keybinds.KeyBinds;
import dlovin.castiainvtools.network.CITNetworkManager;
import dlovin.castiainvtools.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="castiainvtools")
public class CastiaInvTools {
    public static CastiaInvTools instance;
    public static final String modid = "castiainvtools";
    public static final Logger logger;
    private static THLConfig CONFIG;
    private ClientEvents clientEvents;
    private ConfigValues configValues;
    private KeyBinds keyBinds;
    private List<CastiaOverlay> overlayList;

    public CastiaInvTools(IEventBus modEventBus, ModContainer modContainer) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        CONFIG = new THLConfig();
        CONFIG.register(modContainer);
        instance = this;
        this.configValues = new ConfigValues();
        this.overlayList = new ArrayList<CastiaOverlay>();
        this.overlayList.add(new IconsOverlay(this.configValues));
        if (ModList.get().isLoaded("inventoryhud")) {
            this.overlayList.add(new InvHudOverlay(this.configValues));
        }
        this.keyBinds = new KeyBinds(this.configValues);
        modEventBus.addListener(this.keyBinds::onKeyReg);
        modEventBus.addListener(this::clientRegistries);
        CastiaInvToolsConfigScreenHandler.init();
        CITNetworkManager.init(modEventBus);
        modEventBus.addListener(this::onLayerRegistry);
        logger.info("Castia Inventory Tools has been initialised");
    }

    public static THLConfig getConfig() {
        return CONFIG;
    }

    public static CastiaInvTools getInstance() {
        return instance;
    }

    public static ConfigValues configValues() {
        return CastiaInvTools.instance.configValues;
    }

    public List<CastiaOverlay> getOverlays() {
        return this.overlayList;
    }

    public ClientEvents getClientEvents() {
        return this.clientEvents;
    }

    public void initOverlays() {
        this.overlayList.forEach(CastiaOverlay::init);
    }

    public void clientRegistries(FMLClientSetupEvent event) {
        JsonUtils.initForPlayer(Minecraft.getInstance().getUser().getProfileId());
        new ToolsGui(this, this.configValues, NeoForge.EVENT_BUS);
        new KeyEvents(this.keyBinds, NeoForge.EVENT_BUS);
        this.clientEvents = new ClientEvents(this.configValues, NeoForge.EVENT_BUS);
    }

    public void onLayerRegistry(RegisterGuiLayersEvent event) {
        this.overlayList.forEach(layer -> event.registerBelow(VanillaGuiLayers.EFFECTS, ResourceLocation.tryBuild((String)modid, (String)layer.id()), (GuiLayer)layer));
    }

    static {
        logger = LogUtils.getLogger();
    }
}

