/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class CastiaItemColor {
    public ResourceLocation icon;
    public float r;
    public float g;
    public float b;
    public float a;
    public int rawColor;
    public int x;
    public int y;
    public int width;
    public int height;

    public CastiaItemColor(CastiaItemColor c, ResourceLocation icon) {
        this(c.r, c.g, c.b, c.a, icon);
    }

    public CastiaItemColor(CastiaItemColor c, int x, int y, int width, int height, ResourceLocation icon) {
        this(c.r, c.g, c.b, c.a, x, y, width, height, icon);
    }

    public CastiaItemColor(int color, int x, int y, int width, int height, ResourceLocation icon) {
        this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
        this.a = 1.0f;
        this.rawColor = ARGB.color((int)((int)(this.a * 255.0f)), (int)((int)(this.r * 255.0f)), (int)((int)(this.g * 255.0f)), (int)((int)(this.b * 255.0f)));
        this.icon = icon;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public CastiaItemColor(float r, float g, float b, float a, ResourceLocation icon) {
        this(r, g, b, a, 0, 0, 4, 4, icon);
    }

    public CastiaItemColor(float r, float g, float b, float a, int x, int y, int width, int height, ResourceLocation icon) {
        this.rawColor = ARGB.color((int)((int)(a * 255.0f)), (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.icon = icon;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public static CastiaItemColor createCastian(int color, ResourceLocation icon) {
        return new CastiaItemColor(color, 0, 0, 7, 6, icon);
    }

    public static CastiaItemColor createCastian(CastiaItemColor color, ResourceLocation icon) {
        return new CastiaItemColor(color, 0, 0, 7, 6, icon);
    }

    @Deprecated
    public boolean equals(CastiaItemColor color) {
        return color.r == this.r && color.g == this.g && color.b == this.b && color.a == this.a;
    }
}

