/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui.overlays;

import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.gui.CastiaItemColor;
import dlovin.castiainvtools.gui.CastiaItemTiers;
import dlovin.castiainvtools.gui.overlays.CastiaOverlay;
import dlovin.utils.helpers.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.inventory.Slot;

public class IconsOverlay
extends CastiaOverlay {
    private Minecraft mc;
    private final ConfigValues configValues;

    public IconsOverlay(ConfigValues configValues) {
        super("castia_tier_icons");
        this.configValues = configValues;
    }

    private List<Runnable> getCastiaDraws(GuiGraphics context, int width, int height) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (int i = 0; i < 9; ++i) {
            CastiaItemColor hotBar = CastiaItemTiers.getTierColor(((Slot)this.mc.player.inventoryMenu.slots.get(i + 36)).getItem(), this.configValues.keepMithrilIconRed);
            if (hotBar == null) continue;
            int finalI = i;
            result.add(() -> RenderHelper.drawTexture(context, hotBar.icon, width + finalI * 20 + hotBar.x, height + hotBar.y, hotBar.width, hotBar.height, hotBar.rawColor));
        }
        CastiaItemColor offhand = CastiaItemTiers.getTierColor(this.mc.player.getOffhandItem(), this.configValues.keepMithrilIconRed);
        if (offhand != null) {
            int offset = this.mc.player.getMainArm().equals((Object)HumanoidArm.RIGHT) ? -29 : 189;
            result.add(() -> RenderHelper.drawTexture(context, offhand.icon, width + offset + offhand.x, height + offhand.y, offhand.width, offhand.height, offhand.rawColor));
        }
        return result;
    }

    public void render(GuiGraphics context, DeltaTracker deltaTracker) {
        int height;
        if (!this.configValues.anyTierIcon) {
            return;
        }
        if (!this.configValues.isOnCastia) {
            return;
        }
        int width = context.guiWidth() / 2 - 88;
        List<Runnable> draws = this.getCastiaDraws(context, width, height = context.guiHeight() - 19);
        if (draws.isEmpty()) {
            return;
        }
        context.pose().pushMatrix();
        draws.forEach(Runnable::run);
        context.pose().popMatrix();
    }

    @Override
    public void init() {
        this.mc = Minecraft.getInstance();
    }
}

