/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui.screens;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.enums.LeftMode;
import dlovin.castiainvtools.enums.SkillMessageType;
import dlovin.castiainvtools.gui.screens.ScreenWithList;
import dlovin.castiainvtools.gui.screens.SoundConfigScreen;
import dlovin.castiainvtools.gui.screens.TierConfigGui;
import dlovin.utils.widgets.ButtonWidget;
import dlovin.utils.widgets.CheckBox;
import dlovin.utils.widgets.CustomButton;
import dlovin.utils.widgets.CustomOptionList;
import dlovin.utils.widgets.NumericTextField;
import dlovin.utils.widgets.TextField;
import dlovin.utils.widgets.TextWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigGui
extends ScreenWithList {
    private final ConfigValues configValues = CastiaInvTools.configValues();

    public ConfigGui() {
        super((Component)Component.literal((String)"Castia Inventory Tools Config"));
    }

    @Override
    protected void init() {
        int posX = this.width / 2;
        this.optionList = new CustomOptionList(this.minecraft, this, 32);
        int i = 0;
        this.optionList.addWidget(new TextWidget(posX, "Toggle on/off inventory buttons:", this.font), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Inventory:", this.font), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onInventory, this.configValues.inventoryButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Craft:", this.font), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onCraft, this.configValues.craftButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Ender chest:", this.font), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onEnder, this.configValues.enderChestButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Player Vault:", this.font), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onPV, this.configValues.playerVaultButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Town Vault:", this.font), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onTV, this.configValues.townVaultButton), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Trash:", this.font), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onTrash, this.configValues.trashButton), i++);
        this.optionList.addWidget(new TextWidget(posX, "Skill Earnings Options:", this.font), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Track skill earnings:", this.font), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onJobStats, this.configValues.jobStats), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Skill Earnings last minutes:", this.font), i);
        this.optionList.addWidget(new NumericTextField(this.font, posX + 10, 0, 40, 20, 1, 30, this.configValues.jobStatsCustomValue, this::onJobValue), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Skill Earnings save delay:", this.font), i);
        this.optionList.addWidget(new NumericTextField(this.font, posX + 10, 0, 40, 20, 0, 10, this.configValues.jobStatsSaveDelay, this::onJobSave), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Skill income messages:", this.font), i);
        CustomButton sbtn = new CustomButton(posX + 10, 0, 90, 18, this.configValues.skillsMessages.humanize(), null, false);
        sbtn.addListener(this::onSkillMessage);
        this.optionList.addWidget(sbtn, i++);
        this.optionList.addWidget(new TextWidget(posX, "Other Options:", this.font), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Tier Icons Menu:", this.font), i);
        CustomButton tbtn = new CustomButton(posX + 10, 0, 50, 18, "Open", null, false);
        tbtn.addListener(this::onTierMenu);
        this.optionList.addWidget(tbtn, i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Castia Sounds Menu:", this.font), i);
        CustomButton sound = new CustomButton(posX + 10, 0, 50, 18, "Sound", null, false);
        sound.addListener(btn -> Minecraft.getInstance().setScreen((Screen)new SoundConfigScreen(this)));
        this.optionList.addWidget(sound, i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Left side mode:", this.font), i);
        CustomButton cbtn = new CustomButton(posX + 10, 0, 90, 18, this.configValues.leftMode.toString(), null, false);
        cbtn.addListener(this::onLeftMode);
        this.optionList.addWidget(cbtn, i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Emoji Buttons:", this.font), i);
        this.optionList.addWidget(new CheckBox(posX + 10, 2, 16, 16, this::onEmojiButtons, this.configValues.emojiButtons), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Private Vault Max Count:", this.font), i);
        this.optionList.addWidget(new NumericTextField(this.font, posX + 10, 0, 40, 20, 1, 50, this.configValues.playerVaultsCount, this::onPvChanged), i++);
        this.optionList.addWidget(new TextWidget(posX - 20, "Town Vault Max Count:", this.font), i);
        this.optionList.addWidget(new NumericTextField(this.font, posX + 10, 0, 40, 20, 1, 50, this.configValues.townVaultsCount, this::onTvChanged), i);
        this.children().add(this.optionList);
    }

    private void onJobSave(TextField btn) {
        try {
            int value;
            this.configValues.jobStatsSaveDelay = value = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().getClient().jobStatsSaveDelay.set((Object)value);
            CastiaInvTools.getConfig().clientSpec.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onJobValue(TextField btn) {
        try {
            int value;
            this.configValues.jobStatsCustomValue = value = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().getClient().jobStatsCustomValue.set((Object)value);
            CastiaInvTools.getConfig().clientSpec.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onJobStats(CheckBox box) {
        CastiaInvTools.getConfig().getClient().jobStats.set((Object)box.checked);
        this.configValues.jobStats = box.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onSkillMessage(ButtonWidget btn) {
        SkillMessageType stype = ((SkillMessageType)((Object)CastiaInvTools.getConfig().getClient().skillMessages.get())).next();
        CastiaInvTools.getConfig().getClient().skillMessages.set((Object)stype);
        this.configValues.skillsMessages = stype;
        btn.setMessage(stype.humanize());
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onEmojiButtons(CheckBox box) {
        CastiaInvTools.getConfig().getClient().emojiButtons.set((Object)box.checked);
        this.configValues.emojiButtons = box.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onTierMenu(ButtonWidget btn) {
        Minecraft.getInstance().setScreen((Screen)new TierConfigGui(this));
    }

    private void onLeftMode(ButtonWidget btn) {
        LeftMode mode = ((LeftMode)((Object)CastiaInvTools.getConfig().getClient().leftMode.get())).next();
        CastiaInvTools.getConfig().getClient().leftMode.set((Object)mode);
        this.configValues.leftMode = mode;
        btn.setMessage(mode.toString());
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onPvChanged(TextField btn) {
        try {
            int pv;
            this.configValues.playerVaultsCount = pv = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().getClient().pvMax.set((Object)pv);
            CastiaInvTools.getConfig().clientSpec.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onTvChanged(TextField btn) {
        try {
            int pv;
            this.configValues.townVaultsCount = pv = Integer.parseInt(btn.getText());
            CastiaInvTools.getConfig().getClient().tvMax.set((Object)pv);
            CastiaInvTools.getConfig().clientSpec.save();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onTrash(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().trBtn.set((Object)btn.checked);
        this.configValues.trashButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onPV(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().pvBtn.set((Object)btn.checked);
        this.configValues.playerVaultButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onTV(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().tvBtn.set((Object)btn.checked);
        this.configValues.townVaultButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onEnder(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().ecBtn.set((Object)btn.checked);
        this.configValues.enderChestButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onCraft(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().crBtn.set((Object)btn.checked);
        this.configValues.craftButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }

    private void onInventory(CheckBox btn) {
        CastiaInvTools.getConfig().getClient().invBtn.set((Object)btn.checked);
        this.configValues.inventoryButton = btn.checked;
        CastiaInvTools.getConfig().clientSpec.save();
    }
}

