/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.utils;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class SoundUtils {
    private static final Map<ResourceLocation, Supplier<Double>> SOUNDS_TO_PROCESS = new HashMap<ResourceLocation, Supplier<Double>>(){
        {
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.ui.toast.challenge_complete"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundQuestComplete.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.generic.explode"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundGemstone.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.player.levelup"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundLevelUp.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.lightning_bolt.impact"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundBomb.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.firework_rocket.blast"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundRtp.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"block.note_block.bell"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundLlama.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"block.note_block.chime"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundLlama.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"block.amethyst_block.break"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundLlama.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.llama.spit"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundLlama.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.allay.death"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundMushroom.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.camel.eat"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundMushroom.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.cat.ambient"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundCore.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"vein_miner"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundVeinMiner.get());
            this.put(ResourceLocation.withDefaultNamespace((String)"treefeller"), () -> (Double)CastiaInvTools.getConfig().getClient().soundMaster.get() * (Double)CastiaInvTools.getConfig().getClient().soundTreefeller.get());
        }
    };

    public static void patchSoundPacket(ClientboundSoundPacket packet) {
        if (packet.getSource().equals((Object)SoundSource.MASTER) && SOUNDS_TO_PROCESS.containsKey(((SoundEvent)packet.getSound().value()).location())) {
            Field f = ReflectionUtils.getFieldByType(packet, ClientboundSoundPacket.class, Float.TYPE, 1);
            if (f == null) {
                return;
            }
            try {
                f.setFloat(packet, SOUNDS_TO_PROCESS.get(((SoundEvent)packet.getSound().value()).location()).get().floatValue());
            }
            catch (IllegalAccessException | NullPointerException exception) {
                // empty catch block
            }
        }
    }

    public static void patchSoundPacket(ClientboundSoundEntityPacket packet) {
        if (packet.getSource().equals((Object)SoundSource.MASTER) && SOUNDS_TO_PROCESS.containsKey(((SoundEvent)packet.getSound().value()).location())) {
            Field f = ReflectionUtils.getFieldByType(packet, ClientboundSoundEntityPacket.class, Float.TYPE);
            if (f == null) {
                return;
            }
            try {
                f.setFloat(packet, SOUNDS_TO_PROCESS.get(((SoundEvent)packet.getSound().value()).location()).get().floatValue());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

