/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools;

import com.mojang.logging.LogUtils;
import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.config.THLConfig;
import dlovin.castiainvtools.events.ClientEvents;
import dlovin.castiainvtools.events.KeyEvents;
import dlovin.castiainvtools.gui.ToolsGui;
import dlovin.castiainvtools.gui.overlays.CastiaOverlay;
import dlovin.castiainvtools.gui.overlays.IconsOverlay;
import dlovin.castiainvtools.gui.overlays.InvHudOverlay;
import dlovin.castiainvtools.gui.screens.ConfigGui;
import dlovin.castiainvtools.keybinds.KeyBinds;
import dlovin.castiainvtools.network.CITNetworkManager;
import dlovin.castiainvtools.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.AddGuiOverlayLayersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.ForgeLayeredDraw;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="castiainvtools")
public class CastiaInvTools {
    public static CastiaInvTools instance;
    public static final String modid = "castiainvtools";
    public static final Logger logger;
    private static THLConfig CONFIG;
    private ClientEvents clientEvents;
    private ConfigValues configValues;
    private KeyBinds keyBinds;
    private List<CastiaOverlay> overlayList;

    public CastiaInvTools(FMLJavaModLoadingContext context) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        JsonUtils.initForPlayer(Minecraft.getInstance().getUser().getProfileId());
        CONFIG = new THLConfig();
        CONFIG.register((ModLoadingContext)context);
        instance = this;
        this.configValues = new ConfigValues();
        this.overlayList = new ArrayList<CastiaOverlay>();
        this.overlayList.add(new IconsOverlay(this.configValues));
        if (ModList.get().isLoaded("inventoryhud")) {
            this.overlayList.add(new InvHudOverlay(this.configValues));
        }
        BusGroup modBusGroup = context.getModBusGroup();
        this.keyBinds = new KeyBinds(this.configValues);
        RegisterKeyMappingsEvent.getBus((BusGroup)modBusGroup).addListener(v -> this.keyBinds.onKeyReg((RegisterKeyMappingsEvent)v));
        FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::clientRegistries);
        context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ConfigGui()));
        CITNetworkManager.init();
        AddGuiOverlayLayersEvent.getBus((BusGroup)modBusGroup).addListener(this::registerLayers);
        logger.info("Castia Inventory Tools has been initialised");
    }

    public static THLConfig getConfig() {
        return CONFIG;
    }

    public static CastiaInvTools getInstance() {
        return instance;
    }

    public static ConfigValues configValues() {
        return CastiaInvTools.instance.configValues;
    }

    public List<CastiaOverlay> getOverlays() {
        return this.overlayList;
    }

    public ClientEvents getClientEvents() {
        return this.clientEvents;
    }

    public void initOverlays() {
        this.overlayList.forEach(CastiaOverlay::init);
    }

    public void clientRegistries(FMLClientSetupEvent event) {
        new ToolsGui(this, this.configValues);
        new KeyEvents(this.keyBinds);
        this.clientEvents = new ClientEvents(this.configValues);
    }

    private void registerLayers(AddGuiOverlayLayersEvent event) {
        this.overlayList.forEach(o -> event.getLayeredDraw().addAbove(ForgeLayeredDraw.PRE_SLEEP_STACK, ResourceLocation.tryBuild((String)modid, (String)o.id()), ForgeLayeredDraw.HOTBAR_AND_DECOS, o::render));
    }

    static {
        logger = LogUtils.getLogger();
    }
}

