/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.config;

import dlovin.castiainvtools.enums.LeftMode;
import dlovin.castiainvtools.enums.SkillMessageType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class THLConfig {
    public ForgeConfigSpec clientSpec;
    private final Client client;

    public THLConfig() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        this.clientSpec = (ForgeConfigSpec)specPair.getRight();
        this.client = (Client)specPair.getLeft();
    }

    public Client getClient() {
        return this.client;
    }

    public void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.clientSpec);
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue pvMax;
        public final ForgeConfigSpec.IntValue tvMax;
        public final ForgeConfigSpec.IntValue jobStatsCustomValue;
        public final ForgeConfigSpec.IntValue jobStatsSaveDelay;
        public final ForgeConfigSpec.BooleanValue invBtn;
        public final ForgeConfigSpec.BooleanValue crBtn;
        public final ForgeConfigSpec.BooleanValue ecBtn;
        public final ForgeConfigSpec.BooleanValue pvBtn;
        public final ForgeConfigSpec.BooleanValue tvBtn;
        public final ForgeConfigSpec.BooleanValue trBtn;
        public final ForgeConfigSpec.BooleanValue keepMithril;
        public final ForgeConfigSpec.BooleanValue commonTier;
        public final ForgeConfigSpec.BooleanValue rareTier;
        public final ForgeConfigSpec.BooleanValue epicTier;
        public final ForgeConfigSpec.BooleanValue legendaryTier;
        public final ForgeConfigSpec.BooleanValue mithrilTier;
        public final ForgeConfigSpec.BooleanValue begrimedTier;
        public final ForgeConfigSpec.BooleanValue codexTier;
        public final ForgeConfigSpec.BooleanValue emojiButtons;
        public final ForgeConfigSpec.BooleanValue jobStats;
        public final ForgeConfigSpec.EnumValue<SkillMessageType> skillMessages;
        public final ForgeConfigSpec.EnumValue<LeftMode> leftMode;
        public final ForgeConfigSpec.FloatValue soundMaster;
        public final ForgeConfigSpec.FloatValue soundQuestComplete;
        public final ForgeConfigSpec.FloatValue soundGemstone;
        public final ForgeConfigSpec.FloatValue soundLevelUp;
        public final ForgeConfigSpec.FloatValue soundBomb;
        public final ForgeConfigSpec.FloatValue soundRtp;
        public final ForgeConfigSpec.FloatValue soundLlama;
        public final ForgeConfigSpec.FloatValue soundMushroom;
        public final ForgeConfigSpec.FloatValue soundCore;
        public final ForgeConfigSpec.FloatValue soundVeinMiner;
        public final ForgeConfigSpec.FloatValue soundTreefeller;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.pvMax = builder.comment("Private Vault Max Count").translation("castiainvtools.config.client.npv").defineInRange("pvMax", 5, 1, 50);
            this.tvMax = builder.comment("Town Vault Max Count").translation("castiainvtools.config.client.ntv").defineInRange("tvMax", 5, 1, 50);
            this.jobStatsCustomValue = builder.comment("Minutes for custom stats").translation("castiainvtools.config.client.earnings_custom").defineInRange("jobStatsCustomValue", 10, 1, 30);
            this.jobStatsSaveDelay = builder.comment("Delay between saving stats").translation("castiainvtools.config.client.earnings_save").defineInRange("jobStatsSaveDelay", 0, 0, 10);
            this.invBtn = builder.comment("Toggle on/off Inventory button").translation("castiainvtools.config.client.invbtn").define("invBtn", true);
            this.crBtn = builder.comment("Toggle on/off Craft button").translation("castiainvtools.config.client.crbtn").define("crBtn", true);
            this.ecBtn = builder.comment("Toggle on/off Ender chest button").translation("castiainvtools.config.client.ecbtn").define("ecBtn", true);
            this.pvBtn = builder.comment("Toggle on/off PlayerVault button").translation("castiainvtools.config.client.pvbtn").define("pvBtn", true);
            this.tvBtn = builder.comment("Toggle on/off Town Vault button").translation("castiainvtools.config.client.tvbtn").define("tvBtn", true);
            this.trBtn = builder.comment("Toggle on/off Trash button").translation("castiainvtools.config.client.trbtn").define("trBtn", true);
            this.keepMithril = builder.comment("Keep Mithril Icons red").translation("castiainvtools.config.client.keepmithril").define("keepMithril", false);
            this.commonTier = builder.comment("Show Common Tier Icons").translation("castiainvtools.config.client.tiers.common").define("commonTier", true);
            this.rareTier = builder.comment("Show Rare Tier Icons").translation("castiainvtools.config.client.tiers.rare").define("rareTier", true);
            this.epicTier = builder.comment("Show Epic Tier Icons").translation("castiainvtools.config.client.tiers.epic").define("epicTier", true);
            this.legendaryTier = builder.comment("Show Legendary Tier Icons").translation("castiainvtools.config.client.tiers.legendary").define("legendaryTier", true);
            this.mithrilTier = builder.comment("Show Mithril Tier Icons").translation("castiainvtools.config.client.tiers.mithril").define("mithrilTier", true);
            this.begrimedTier = builder.comment("Show Begrimed Tier Icons").translation("castiainvtools.config.client.tiers.begrimed").define("begrimedTier", true);
            this.codexTier = builder.comment("Show Historical Codex Icons").translation("castiainvtools.config.client.tiers.codex").define("codexTier", true);
            this.emojiButtons = builder.comment("Emoji buttons").translation("castianinvtools.config.client.emojibuttons").define("emojiButtons", true);
            this.jobStats = builder.comment("Skills income stats").translation("castianinvtools.config.client.skills_stats").define("jobStats", true);
            this.skillMessages = builder.comment("Skills income messages").translation("castianinvtools.config.client.skills_message").defineEnum("skillMessages", (Enum)SkillMessageType.SERVER_DEFAULT);
            this.leftMode = builder.comment("Should inventory buttons be on left side").defineEnum("leftMode", (Enum)LeftMode.NONE);
            builder.comment("Sound settings").push("sound");
            this.soundMaster = builder.comment("Master volume").translation("castiainvtools.config.client.sound.master").defineInRange("soundMaster", 1.0f, 0.0f, 1.0f);
            this.soundQuestComplete = builder.comment("Quest complete sound").translation("castiainvtools.config.client.sound.quest").defineInRange("soundQuestComplete", 1.0f, 0.0f, 1.0f);
            this.soundGemstone = builder.comment("Gemstone sound").translation("castiainvtools.config.client.sound.gemstone").defineInRange("soundGemstone", 1.0f, 0.0f, 1.0f);
            this.soundLevelUp = builder.comment("Level up sound").translation("castiainvtools.config.client.sound.levelup").defineInRange("soundLevelUp", 1.0f, 0.0f, 1.0f);
            this.soundBomb = builder.comment("Bomb sound").translation("castiainvtools.config.client.sound.bomb").defineInRange("soundBomb", 1.0f, 0.0f, 1.0f);
            this.soundRtp = builder.comment("RTP sound").translation("castiainvtools.config.client.sound.rtp").defineInRange("soundRtp", 1.0f, 0.0f, 1.0f);
            this.soundLlama = builder.comment("Llama + Elevator sounds").translation("castiainvtools.config.client.sound.llama").defineInRange("soundLlama", 1.0f, 0.0f, 1.0f);
            this.soundMushroom = builder.comment("Mushroom sound").translation("castiainvtools.config.client.sound.mushroom").defineInRange("soundMushroom", 1.0f, 0.0f, 1.0f);
            this.soundCore = builder.comment("Core/Spirit sound").translation("castiainvtools.config.client.sound.core").defineInRange("soundCore", 1.0f, 0.0f, 1.0f);
            this.soundVeinMiner = builder.comment("Vein miner sound").translation("castiainvtools.config.client.sound.veinminer").defineInRange("soundVeinMiner", 1.0f, 0.0f, 1.0f);
            this.soundTreefeller = builder.comment("Treefeller sound").translation("castiainvtools.config.client.sound.treefeller").defineInRange("soundTreefeller", 1.0f, 0.0f, 1.0f);
            builder.pop();
            builder.pop();
        }
    }
}

