/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui;

import dlovin.castiainvtools.gui.CastiaItemColor;
import dlovin.castiainvtools.utils.CastiaTier;
import dlovin.castiainvtools.utils.IconUtils;
import java.util.HashMap;
import java.util.NoSuchElementException;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class CastiaItemTiers {
    public static final HashMap<String, CastiaTier> colorMap = new HashMap();

    public static CastiaItemColor getTierColor(ItemStack stack, boolean redMithril) {
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return null;
        }
        try {
            CompoundTag tag = (CompoundTag)((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getCompound("PublicBukkitValues").orElseThrow();
            String tier = tag.getString("oxywire:item_tier").orElse("");
            if (tier.isEmpty()) {
                tier = (String)tag.getString("oxywire:item_id").orElseThrow();
                if (tier.isEmpty()) {
                    return null;
                }
                switch (tier) {
                    case "BegrimedItem": {
                        CastiaTier begrimed = colorMap.get("begrimed");
                        if (!begrimed.enabled) {
                            return null;
                        }
                        return begrimed.color;
                    }
                    case "HistoricalCodex": {
                        CastiaTier codex = colorMap.get("codex");
                        if (!codex.enabled) {
                            return null;
                        }
                        return codex.color;
                    }
                }
                if (!CastiaItemTiers.colorMap.get((Object)"mithril").enabled) {
                    return null;
                }
                return redMithril ? IconUtils.RED_MITHRIL : IconUtils.getColor(CastiaItemTiers.deepColor(stack.getHoverName()));
            }
            CastiaTier castiaTier = colorMap.get(tier);
            return castiaTier.enabled ? castiaTier.color : null;
        }
        catch (NoSuchElementException _ignored) {
            return null;
        }
    }

    private static TextColor deepColor(Component component) {
        Style style = component.getStyle();
        if (style.getColor() != null) {
            return style.getColor();
        }
        for (Component sibling : component.getSiblings()) {
            TextColor color = CastiaItemTiers.deepColor(sibling);
            if (color == null) continue;
            return color;
        }
        return null;
    }

    static {
        colorMap.put("common", new CastiaTier("common", IconUtils.LIGHT_GRAY, true));
        colorMap.put("rare", new CastiaTier("rare", IconUtils.LIGHT_BLUE, true));
        colorMap.put("epic", new CastiaTier("epic", IconUtils.PURPLE, true));
        colorMap.put("legendary", new CastiaTier("legendary", IconUtils.GOLD, true));
        colorMap.put("begrimed", new CastiaTier("begrimed", IconUtils.GRAY, true));
        colorMap.put("codex", new CastiaTier("codex", IconUtils.LIGHT_PURPLE, true));
        colorMap.put("mithril", new CastiaTier("mithril", IconUtils.RED, true));
    }
}

