/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.gui.CastiaItemColor;
import dlovin.castiainvtools.gui.CastiaItemTiers;
import dlovin.castiainvtools.gui.widgets.EmojiWidget;
import dlovin.castiainvtools.gui.widgets.InventoryButton;
import dlovin.castiainvtools.gui.widgets.PVButton;
import dlovin.castiainvtools.gui.widgets.PageButton;
import dlovin.castiainvtools.utils.ChatUtils;
import dlovin.utils.helpers.RenderHelper;
import dlovin.utils.widgets.ButtonWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ToolsGui {
    private final String TRASH_TITLE = "Trashbin";
    private final String PLAYER_VAULT_TITLE = "Vault #";
    private final String TOWN_VAULT_TITLE = "Town Vault";
    private final String ENDER_CHEST_TITLE = "Ender Chest";
    private List<ButtonWidget> invButtons = new ArrayList<ButtonWidget>();
    private List<ButtonWidget> pvButtons = new ArrayList<ButtonWidget>();
    private EmojiWidget emojiWidget;
    private long preTime = 0L;
    private boolean buttonClicked = false;
    private final ConfigValues configValues;
    private Minecraft minecraft = Minecraft.getInstance();

    public ToolsGui(CastiaInvTools plugin, ConfigValues configValues) {
        this.configValues = configValues;
        this.configValues.init();
        plugin.initOverlays();
        InputEvent.MouseButton.Pre.BUS.addListener(this::onMouse);
        ScreenEvent.Init.Pre.BUS.addListener(this::onContainerOpen);
        ScreenEvent.Render.Pre.BUS.addListener(this::onChatScreen);
        ContainerScreenEvent.Render.Foreground.BUS.addListener(this::onScreen);
    }

    @SubscribeEvent
    public boolean onMouse(InputEvent.MouseButton.Pre event) {
        if (this.minecraft.screen instanceof AbstractContainerScreen) {
            if (event.getAction() == 1 && event.getButton() == 0) {
                for (ButtonWidget b : this.invButtons) {
                    if (!b.isMouseOver(0.0, 0.0)) continue;
                    this.buttonClicked = true;
                    return true;
                }
                for (ButtonWidget b : this.pvButtons) {
                    if (!b.isMouseOver(0.0, 0.0)) continue;
                    this.buttonClicked = true;
                    return true;
                }
            }
        } else if (this.minecraft.screen instanceof ChatScreen && event.getAction() == 1 && event.getButton() == 0) {
            return this.emojiWidget != null && this.emojiWidget.handleClick();
        }
        return false;
    }

    @SubscribeEvent
    public void onContainerOpen(ScreenEvent.Init.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            this.setupContainerButtons(gui);
        } else if (event.getScreen() instanceof ChatScreen && this.configValues.isOnCastia && this.configValues.emojiButtons) {
            this.emojiWidget = new EmojiWidget();
        }
    }

    private void setupContainerButtons(AbstractContainerScreen gui) {
        boolean leftInv = this.configValues.leftMode.isLeft(gui.showsActiveEffects());
        int xpos = leftInv ? -23 : gui.getXSize();
        int ypos = gui.getYSize() - 3;
        int pvXLeft = gui.getGuiLeft();
        int pvXRight = gui.getXSize();
        int pvYpos = gui.getGuiTop() + 3;
        String title = gui.getTitle().getString();
        int i = 1;
        this.invButtons = new ArrayList<ButtonWidget>();
        if (this.configValues.trashButton && !title.contains("Trashbin")) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", ResourceLocation.tryBuild((String)"castiainvtools", (String)"textures/gui/trash_icon.png"), btn -> this.onBTN("trash"), leftInv));
            ++i;
        }
        if (this.configValues.townVaultButton && !title.contains("Town Vault")) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", ResourceLocation.tryBuild((String)"castiainvtools", (String)"textures/gui/tv_icon.png"), btn -> this.onBTN("t v " + this.configValues.lastTownVault), leftInv));
            ++i;
        }
        if (this.configValues.playerVaultButton && !title.contains("Vault #")) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", ResourceLocation.tryBuild((String)"castiainvtools", (String)"textures/gui/pv_icon.png"), btn -> this.onBTN("pv " + this.configValues.lastPlayerVault), leftInv));
            ++i;
        }
        if (this.configValues.enderChestButton && !title.contains("Ender Chest")) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", ResourceLocation.tryBuild((String)"castiainvtools", (String)"textures/gui/ec_icon.png"), btn -> this.onBTN("ec"), leftInv));
            ++i;
        }
        if (this.configValues.craftButton && !(gui instanceof CraftingScreen)) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", ResourceLocation.tryBuild((String)"castiainvtools", (String)"textures/gui/cr_icon.png"), btn -> this.onBTN("craft"), leftInv));
            ++i;
        }
        if (this.configValues.inventoryButton && !(gui instanceof InventoryScreen)) {
            this.invButtons.add(new InventoryButton(xpos, ypos - 20 * i, 23, 19, "b", ResourceLocation.tryBuild((String)"castiainvtools", (String)"textures/gui/inv_icon.png"), btn -> this.onBTN(""), leftInv));
        }
        this.createVaultButtons(0, pvXRight, pvXLeft, pvYpos, title);
    }

    private void createVaultButtons(int page, int xpos, int pvXpos, int pvYpos, String title) {
        boolean cpv;
        int pvI;
        int j;
        String commandPrefix;
        int max;
        this.pvButtons = new ArrayList<ButtonWidget>();
        int index = 0;
        if (title.contains("Vault #")) {
            this.configValues.lastPlayerVault = index = Integer.parseInt(title.split("Vault #")[1]);
            max = this.configValues.playerVaultsCount;
            commandPrefix = "pv";
        } else if (title.contains("Town Vault")) {
            max = this.configValues.townVaultsCount;
            commandPrefix = "t v";
        } else {
            return;
        }
        boolean tVault = title.contains("Town Vault");
        int pageMultiplier = page == 0 ? (index - 1) / 10 : page - 1;
        for (j = 0; j < 5 && (pvI = pageMultiplier * 10 + j + 1) <= max; ++j) {
            cpv = pvI == index;
            String command = String.format("%s %d", commandPrefix, pvI);
            this.pvButtons.add(new PVButton(pvXpos - 23, pvYpos + j * 15, cpv ? 26 : 23, 14, "b", cpv, true, pvI, cpv ? btn -> {} : btn -> {
                this.onBTN(command);
                if (tVault) {
                    this.configValues.lastTownVault = pvI;
                }
            }));
        }
        for (j = 0; j < 5 && (pvI = pageMultiplier * 10 + j + 1 + 5) <= max; ++j) {
            cpv = pvI == index;
            int xoff = cpv ? 3 : 0;
            String command = String.format("%s %d", commandPrefix, pvI);
            this.pvButtons.add(new PVButton(xpos - xoff, pvYpos + j * 15, cpv ? 26 : 23, 14, "b", cpv, false, pvI, cpv ? btn -> {} : btn -> {
                this.onBTN(command);
                if (tVault) {
                    this.configValues.lastTownVault = pvI;
                }
            }));
        }
        if (max > (pageMultiplier + 1) * 10) {
            this.pvButtons.add(new PageButton(xpos + 3, pvXpos - 16, 13, 13, "b", false, btn -> this.createVaultButtons(pageMultiplier + 2, xpos, pvXpos, pvYpos, title)));
        }
        if (pageMultiplier > 0) {
            this.pvButtons.add(new PageButton(pvXpos - 16, pvYpos - 16, 13, 13, "b", true, btn -> this.createVaultButtons(pageMultiplier, xpos, pvXpos, pvYpos, title)));
        }
    }

    private void onBTN(String s) {
        this.minecraft.player.closeContainer();
        if (s != "") {
            ChatUtils.sendCommandByLocal(s);
        } else {
            this.minecraft.setScreen((Screen)new InventoryScreen((Player)this.minecraft.player));
        }
    }

    private List<Runnable> getCastiaDraws(GuiGraphics context, List<Slot> slots) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (Slot slot : slots) {
            CastiaItemColor tier = CastiaItemTiers.getTierColor(slot.getItem(), this.configValues.keepMithrilIconRed);
            if (tier == null) continue;
            result.add(() -> RenderHelper.drawTexture(context, tier.icon, slot.x + tier.x, slot.y + tier.y, tier.width, tier.height, tier.rawColor));
        }
        return result;
    }

    private void renderOverlay(AbstractContainerScreen screen, GuiGraphics context) {
        if (!this.configValues.isOnCastia || !this.configValues.anyTierIcon) {
            return;
        }
        List<Runnable> draws = this.getCastiaDraws(context, (List<Slot>)screen.getMenu().slots);
        if (!draws.isEmpty()) {
            context.pose().pushMatrix();
            draws.forEach(Runnable::run);
            context.pose().popMatrix();
        }
    }

    @SubscribeEvent
    public void onChatScreen(ScreenEvent.Render.Pre event) {
        if (event.getScreen() instanceof ChatScreen && this.configValues.isOnCastia && this.configValues.emojiButtons && this.emojiWidget != null) {
            this.emojiWidget.render(event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public void onScreen(ContainerScreenEvent.Render.Foreground event) {
        GuiGraphics context = event.getGuiGraphics();
        this.renderOverlay(event.getContainerScreen(), context);
        int xMouse = event.getMouseX() - event.getContainerScreen().getGuiLeft();
        int yMouse = event.getMouseY() - event.getContainerScreen().getGuiTop();
        ArrayList<Runnable> r = new ArrayList<Runnable>();
        for (ButtonWidget btn : this.invButtons) {
            btn.render(context, xMouse, yMouse, this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(false));
            if (!this.buttonClicked) continue;
            r.add(() -> btn.mouseClicked(xMouse, yMouse, 0));
        }
        for (ButtonWidget btn : this.pvButtons) {
            btn.render(context, xMouse, yMouse, this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(false));
            if (!this.buttonClicked) continue;
            r.add(() -> btn.mouseClicked(xMouse, yMouse, 0));
        }
        r.forEach(Runnable::run);
        this.buttonClicked = false;
    }
}

