/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui.overlays;

import dlovin.castiainvtools.config.ConfigValues;
import dlovin.castiainvtools.gui.CastiaItemColor;
import dlovin.castiainvtools.gui.CastiaItemTiers;
import dlovin.castiainvtools.gui.overlays.CastiaOverlay;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.utils.WidgetAligns;
import dlovin.utils.helpers.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public class InvHudOverlay
extends CastiaOverlay {
    private Minecraft mc;
    private final ConfigValues configValues;

    public InvHudOverlay(ConfigValues configValues) {
        super("inv_hud_castia_tier_icons");
        this.configValues = configValues;
    }

    private List<Runnable> getCastiaDraws(GuiGraphics context, int iMax, int jMax) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = InventoryGui.invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                CastiaItemColor tier = CastiaItemTiers.getTierColor(this.mc.player.getInventory().getItem(index), this.configValues.keepMithrilIconRed);
                if (tier == null) continue;
                int finalI = i;
                int finalJ = j;
                result.add(() -> RenderHelper.drawTexture(context, tier.icon, finalI * 18 + tier.x, finalJ * 18 + tier.y, tier.width, tier.height, tier.rawColor));
            }
        }
        return result;
    }

    @Override
    public void render(GuiGraphics context, DeltaTracker ticker) {
        int jMax;
        if (!this.checkConditions()) {
            return;
        }
        int iMax = InventoryGui.invVert ? 3 : 9;
        List<Runnable> draws = this.getCastiaDraws(context, iMax, jMax = InventoryGui.invVert ? 9 : 3);
        if (draws.isEmpty()) {
            return;
        }
        int width = this.mc.getWindow().getGuiScaledWidth();
        int height = this.mc.getWindow().getGuiScaledHeight();
        float scale = InventoryGui.invMini ? 0.75f : 1.0f;
        int px = switch (InventoryGui.InvAligns.HorAlign) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.HAlign.LEFT -> InventoryGui.invX;
            case WidgetAligns.HAlign.MIDDLE -> (int)((float)width / 2.0f - (float)(iMax * 9) * scale - (float)InventoryGui.invX);
            case WidgetAligns.HAlign.RIGHT -> width - InventoryGui.invX;
        };
        int py = switch (InventoryGui.InvAligns.VertAlign) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.VAlign.TOP -> InventoryGui.invY;
            case WidgetAligns.VAlign.CENTER -> (int)((float)height / 2.0f - (float)(jMax * 9) * scale - (float)InventoryGui.invY);
            case WidgetAligns.VAlign.BOTTOM -> height - InventoryGui.invY;
        };
        context.pose().pushMatrix();
        context.pose().translate((float)px, (float)py);
        context.pose().scale(scale, scale);
        draws.forEach(Runnable::run);
        context.pose().popMatrix();
    }

    private boolean checkConditions() {
        return this.configValues.isOnCastia && this.configValues.anyTierIcon && !(this.mc.screen instanceof AbstractContainerScreen) && InventoryHUD.isActive;
    }

    @Override
    public void init() {
        this.mc = Minecraft.getInstance();
    }
}

