/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.gui.screens;

import dlovin.castiainvtools.gui.screens.ScreenWithList;
import dlovin.castiainvtools.utils.ChatUtils;
import dlovin.utils.widgets.ButtonWidget;
import dlovin.utils.widgets.CustomButton;
import dlovin.utils.widgets.CustomOptionList;
import dlovin.utils.widgets.TextField;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class HomesGui
extends ScreenWithList {
    protected TextField searchField;
    private final String[] homes;
    private String filter = "";
    private int maxwidth;

    public HomesGui(String[] homes) {
        super((Component)Component.literal((String)"Homes"));
        this.homes = (String[])Stream.of(homes).sorted().toArray(String[]::new);
        Font f = Minecraft.getInstance().font;
        for (String s : homes) {
            if (f.width(s) <= this.maxwidth) continue;
            this.maxwidth = f.width(s);
        }
        this.maxwidth += 20;
    }

    protected void init() {
        this.optionList = new CustomOptionList(this.minecraft, this, 32, 30);
        this.initHomes();
        this.searchField = new TextField(this.font, this.width / 2 - this.maxwidth / 2, this.height - 25, this.maxwidth, 20, "", this::filterChanged);
        this.searchField.setMaxStringLength(255);
        this.searchField.setOnSubmit(this::handleSearchSubmit);
        this.children().add(this.optionList);
        this.children().add(this.searchField);
        this.mouseClicked(this.searchField.x + 1, this.searchField.y + 1, 0);
    }

    private void initHomes() {
        int index = 0;
        for (String home : this.homes) {
            if (!this.filter.isEmpty() && !home.toLowerCase().contains(this.filter.toLowerCase())) continue;
            this.addButton(home, index);
            ++index;
        }
    }

    private void addButton(String home, int index) {
        CustomButton tmp = new CustomButton(this.width / 2 - this.maxwidth / 2, 0, this.maxwidth, 20, home, null, false);
        this.optionList.addWidget(tmp, index);
        tmp.addListener(this::handleHomeClick);
    }

    private void filterChanged(TextField field) {
        this.filter = field.getText().toLowerCase();
        this.optionList.clear();
        this.initHomes();
    }

    @Override
    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        super.render(context, mouseX, mouseY, partialTick);
        this.searchField.render(context, mouseX, mouseY, partialTick);
    }

    private void handleHomeClick(ButtonWidget btn) {
        this.teleportToHome(btn.getMessage());
    }

    private void handleSearchSubmit(TextField _field) {
        if (this.optionList.getWidgets().isEmpty()) {
            return;
        }
        this.teleportToHome(this.optionList.getWidgets().getFirst().getMessage());
    }

    private void teleportToHome(String home) {
        ChatUtils.sendCommandByLocal(String.format(Locale.ROOT, "h %s", home));
        Minecraft.getInstance().setScreen(null);
    }
}

