/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dlovin.castiainvtools.utils.jobs.JobEarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonUtils {
    private static String path;

    public static void initForPlayer(UUID playerUUID) {
        path = String.format("%s/%s/%s/", FMLPaths.CONFIGDIR.get(), "CastiaInventoryTools/income/season3", playerUUID.toString());
    }

    public static void loadValues(JobEarnings earnings) {
        JsonUtils.loadMonthData(earnings);
        JsonUtils.getOverallValue(earnings);
    }

    private static void loadMonthData(JobEarnings earnings) {
        String currentMonth = new SimpleDateFormat("yyyy-MM").format(Calendar.getInstance().getTime());
        String filePath = path + currentMonth + ".json";
        HashMap<String, Double> dailyDataMap = new HashMap<String, Double>();
        HashMap<String, Double> monthValueMap = new HashMap<String, Double>();
        try {
            String content = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            JsonElement jsonElement = JsonParser.parseString((String)content);
            JsonObject rootNode = jsonElement.getAsJsonObject();
            double monthValue = rootNode.get("month").getAsDouble();
            monthValueMap.put(currentMonth, monthValue);
            JsonObject dailyDataNode = rootNode.getAsJsonObject("data");
            Set entries = dailyDataNode.entrySet();
            for (Map.Entry entry : entries) {
                dailyDataMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble());
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            e.printStackTrace();
        }
        earnings.setDailyIncome(dailyDataMap);
        earnings.setMonthlyIncome(monthValueMap);
    }

    private static void getOverallValue(JobEarnings earnings) {
        double overallValue = 0.0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(path, new String[0]), "*.json");){
            for (Path file : stream) {
                String fileName = file.getFileName().toString();
                if (!fileName.matches("\\d{4}-\\d{2}\\.json")) continue;
                try {
                    String content = new String(Files.readAllBytes(file));
                    JsonElement jsonElement = JsonParser.parseString((String)content);
                    JsonObject rootNode = jsonElement.getAsJsonObject();
                    if (!rootNode.has("month")) continue;
                    overallValue += rootNode.get("month").getAsDouble();
                }
                catch (JsonParseException | IOException | IllegalStateException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        earnings.setOverallValue(overallValue);
    }

    public static void saveValues(JobEarnings earnings) {
        JsonUtils.saveMonthData(earnings);
    }

    private static void saveMonthData(JobEarnings earnings) {
        try {
            HashMap<String, Map> monthlyDataMap = new HashMap<String, Map>();
            for (Map.Entry<String, Double> entry : earnings.getDailyIncome().entrySet()) {
                String[] dateParts = entry.getKey().split("-");
                String monthKey = dateParts[0] + "-" + dateParts[1];
                monthlyDataMap.computeIfAbsent(monthKey, k -> new HashMap()).put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Double> entry : monthlyDataMap.entrySet()) {
                String month = entry.getKey();
                String filePath = path + month + ".json";
                JsonObject rootNode = new JsonObject();
                rootNode.addProperty("month", (Number)earnings.getMonthlyIncome().get(month));
                JsonObject dailyDataNode = new JsonObject();
                for (Map.Entry entry2 : ((Map)((Object)entry.getValue())).entrySet()) {
                    dailyDataNode.addProperty((String)entry2.getKey(), (Number)entry2.getValue());
                }
                rootNode.add("data", (JsonElement)dailyDataNode);
                JsonUtils.writeToFile(filePath, rootNode.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeToFile(String filePath, String content) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        Path tempPath = Paths.get(filePath + ".tmp", new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (FileChannel channel = FileChannel.open(tempPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            channel.write(ByteBuffer.wrap(bytes));
            channel.force(true);
        }
        Files.move(tempPath, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
    }
}

