/*
 * Decompiled with CFR 0.152.
 */
package dlovin.castiainvtools.utils;

import dlovin.castiainvtools.CastiaInvTools;
import dlovin.castiainvtools.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class SoundUtils {
    private static final Map<ResourceLocation, Supplier<Float>> SOUNDS_TO_PROCESS = new HashMap<ResourceLocation, Supplier<Float>>(){
        {
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.ui.toast.challenge_complete"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundQuestComplete.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.generic.explode"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundGemstone.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.player.levelup"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundLevelUp.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.lightning_bolt.impact"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundBomb.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.firework_rocket.blast"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundRtp.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"block.note_block.bell"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundLlama.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"block.note_block.chime"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundLlama.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"block.amethyst_block.break"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundLlama.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.llama.spit"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundLlama.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.allay.death"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundMushroom.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.camel.eat"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundMushroom.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"entity.cat.ambient"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundCore.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"vein_miner"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundVeinMiner.get()).floatValue()));
            this.put(ResourceLocation.withDefaultNamespace((String)"treefeller"), () -> Float.valueOf(((Float)CastiaInvTools.getConfig().getClient().soundMaster.get()).floatValue() * ((Float)CastiaInvTools.getConfig().getClient().soundTreefeller.get()).floatValue()));
        }
    };

    public static void patchSoundPacket(ClientboundSoundPacket packet) {
        if (packet.getSource().equals((Object)SoundSource.MASTER) && SOUNDS_TO_PROCESS.containsKey(((SoundEvent)packet.getSound().get()).location())) {
            Field f = ReflectionUtils.getFieldByType(packet, ClientboundSoundPacket.class, Float.TYPE, 1);
            if (f == null) {
                return;
            }
            try {
                f.setFloat(packet, SOUNDS_TO_PROCESS.get(((SoundEvent)packet.getSound().get()).location()).get().floatValue());
            }
            catch (IllegalAccessException | NullPointerException exception) {
                // empty catch block
            }
        }
    }

    public static void patchSoundPacket(ClientboundSoundEntityPacket packet) {
        if (packet.getSource().equals((Object)SoundSource.MASTER) && SOUNDS_TO_PROCESS.containsKey(((SoundEvent)packet.getSound().get()).location())) {
            Field f = ReflectionUtils.getFieldByType(packet, ClientboundSoundEntityPacket.class, Float.TYPE);
            if (f == null) {
                return;
            }
            try {
                f.setFloat(packet, SOUNDS_TO_PROCESS.get(((SoundEvent)packet.getSound().get()).location()).get().floatValue());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

