/*
 * Decompiled with CFR 0.152.
 */
package dlovin.utils.widgets;

import dlovin.utils.widgets.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;

public class ButtonWidget
extends Widget {
    protected final List<ButtonClickListener> listeners = new ArrayList<ButtonClickListener>();

    public void addListener(ButtonClickListener act) {
        this.listeners.add(act);
    }

    public ButtonWidget(int x, int y, int widthIn, int heightIn, String buttonText) {
        super(x, y, widthIn, heightIn, buttonText);
    }

    public ButtonWidget(int x, int y, int widthIn, int heightIn, String buttonText, Widget.ITooltip iTooltip) {
        super(x, y, widthIn, heightIn, buttonText, iTooltip);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hovered) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            for (ButtonClickListener hl : this.listeners) {
                hl.onClick(this);
            }
            return true;
        }
        return false;
    }

    public void playDownSound(SoundManager soundManager) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public static interface ButtonClickListener {
        public void onClick(ButtonWidget var1);
    }
}

