/*
 * Decompiled with CFR 0.152.
 */
package dlovin.utils.widgets;

import dlovin.utils.widgets.ButtonWidget;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SliderWidget
extends ButtonWidget {
    private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider");
    private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_highlighted");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted");
    protected double value;
    private boolean canChangeValue;
    private String name;
    private int isDragging = -1;

    public SliderWidget(int x, int y, int width, int height, String message, double value, ButtonWidget.ButtonClickListener onApply) {
        super(x, y, width, height, message);
        this.name = message;
        this.value = value;
        this.listeners.add(onApply);
        this.updateMessage();
    }

    public double getValue() {
        return this.value;
    }

    protected ResourceLocation getSprite() {
        return this.isActive() && this.isFocused() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    protected ResourceLocation getHandleSprite() {
        return !this.isActive() || !this.hovered && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    @Override
    public void render(GuiGraphics gui, int mx, int my, float pTick) {
        super.render(gui, mx, my, pTick);
        Minecraft minecraft = Minecraft.getInstance();
        gui.blitSprite(RenderPipelines.GUI_TEXTURED, this.getSprite(), this.x, this.y, this.width, this.height, -1);
        gui.blitSprite(RenderPipelines.GUI_TEXTURED, this.getHandleSprite(), this.x + (int)(this.value * (double)(this.width - 8)), this.y, 8, this.height, -1);
        gui.drawCenteredString(minecraft.font, this.getMessage(), this.x + this.width / 2, this.y + this.height / 2 - 4, -1);
    }

    @Override
    public boolean mouseClicked(double mx, double my, int button) {
        if (!this.hovered) {
            return false;
        }
        this.isDragging = button;
        this.setValueFromMouse(mx);
        return true;
    }

    @Override
    public void setFocused(boolean p_265705_) {
        super.setFocused(p_265705_);
        if (!p_265705_) {
            this.canChangeValue = false;
        } else {
            InputType inputtype = Minecraft.getInstance().getLastInputType();
            if (inputtype == InputType.MOUSE || inputtype == InputType.KEYBOARD_TAB) {
                this.canChangeValue = true;
            }
        }
    }

    @Override
    public boolean keyPressed(int p_93596_, int p_93597_, int p_93598_) {
        if (CommonInputs.selected((int)p_93596_)) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean flag;
            boolean bl = flag = p_93596_ == 263;
            if (flag || p_93596_ == 262) {
                float f = flag ? -1.0f : 1.0f;
                this.setValue(this.value + (double)(f / (float)(this.width - 8)));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mx) {
        this.setValue((mx - (double)(this.x + 4)) / (double)(this.width - 8));
    }

    private void setValue(double p_93612_) {
        double d0 = this.value;
        this.value = Mth.clamp((double)p_93612_, (double)0.0, (double)1.0);
        if (d0 != this.value) {
            this.listeners.forEach(l -> l.onClick(this));
        }
        this.updateMessage();
    }

    @Override
    public boolean mouseDragged(double mx, double my, int mb, double deltaX, double deltaY) {
        if (this.isDragging != mb) {
            return false;
        }
        this.setValueFromMouse(mx);
        return true;
    }

    @Override
    public boolean mouseReleased(double mx, double my, int button) {
        if (this.isDragging == button) {
            this.isDragging = -1;
            super.playDownSound(Minecraft.getInstance().getSoundManager());
        }
        return this.hovered;
    }

    protected void updateMessage() {
        this.setMessage(this.name + ": " + (int)(this.value * 100.0) + "%");
    }
}

