/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism;

import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.data.MysticismLanguageProvider;
import io.github.Memoires.trmysticism.data.gen.MysticismBiomeMagiculeModifiersProvider;
import io.github.Memoires.trmysticism.data.gen.MysticismGlobalLootModifiersProvider;
import io.github.Memoires.trmysticism.data.gen.MysticismLevelMagiculeModifiersProvider;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.registry.MysticismRegistry;
import io.github.Memoires.trmysticism.world.MysticismWorldGeneration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="trmysticism")
public class TensuraMysticism {
    public static final String MOD_ID = "trmysticism";
    public static final String MOD_VERSION = "v1.1.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"trmysticism");
    public static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trmysticism", "network"), () -> "1.0", s -> true, s -> true);

    public TensuraMysticism() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onCommonSetup);
        MysticismRegistry.register(modEventBus);
        modEventBus.addListener(MysticismWorldGeneration::registerBiomeModifiers);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MysticismConfig.SPEC, this.getConfigFileName("mysticism-common"));
        LOGGER.info("Mysticism has been loaded!");
        modEventBus.addListener(this::generateData);
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    private String getConfigFileName(String name) {
        return String.format("%s/%s.toml", "tensura-reincarnated", name);
    }

    private void generateData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.m_236039_(event.includeClient(), (DataProvider)new MysticismLanguageProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new MysticismGlobalLootModifiersProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new MysticismBiomeMagiculeModifiersProvider(event));
        event.getGenerator().m_236039_(event.includeServer(), (DataProvider)new MysticismLevelMagiculeModifiersProvider(event));
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        event.enqueueWork(MysticismNetwork::register);
        if (this.isFirstLaunch()) {
            this.editTOMLFile();
            this.editEngravings();
            this.markAsEdited();
            LOGGER.info("Common setup works and TOML file was edited.");
        } else {
            LOGGER.info("Common setup works. TOML file already edited.");
        }
    }

    private boolean isFirstLaunch() {
        File markerFile = new File("defaultconfigs/tensura-reincarnated/mysticism_first_launch_marker");
        return !markerFile.exists();
    }

    private void markAsEdited() {
        File markerFile = new File("defaultconfigs/tensura-reincarnated/mysticism_first_launch_marker");
        try {
            if (markerFile.createNewFile()) {
                System.out.println("Marker file created: " + markerFile.getAbsolutePath());
            } else {
                System.out.println("Marker file already exists.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error creating marker file: " + e.getMessage());
        }
    }

    public void editTOMLFile() {
        File tomlFile = new File("defaultconfigs/tensura-reincarnated/common.toml");
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(tomlFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                contentBuilder.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error reading the TOML file: " + e.getMessage());
            return;
        }
        String content = contentBuilder.toString();
        String[] newStarting = new String[]{"trmysticism:dragonoid", "trmysticism:sculk_worm", "trmysticism:lesser_spirit", "trmysticism:direwolf", "trmysticism:insect", "trmysticism:lesser_angel", "trmysticism:phantom", "trmysticism:attuned_wyrm"};
        String[] newRandom = new String[]{"trmysticism:dragonoid", "trmysticism:sculk_worm", "trmysticism:lesser_spirit", "trmysticism:direwolf", "trmysticism:insect", "trmysticism:lesser_angel", "trmysticism:phantom", "trmysticism:attuned_wyrm"};
        String[] newSkills = new String[]{"trmysticism:dreamer", "trmysticism:crasher", "trmysticism:hidden_ruler", "trmysticism:stagnator", "trmysticism:plunderer", "trmysticism:compulsor", "trmysticism:cultivator", "trmysticism:spiritualist", "trmysticism:constant", "trmysticism:captivator", "trmysticism:the_balance", "trmysticism:repeater", "trmysticism:gardener", "trmysticism:engineer", "trmysticism:gatekeeper"};
        String[] creatorSkills = new String[]{"trmysticism:dreamer", "trmysticism:crasher", "trmysticism:hidden_ruler", "trmysticism:stagnator", "trmysticism:compulsor", "trmysticism:cultivator", "trmysticism:spiritualist", "trmysticism:constant", "trmysticism:captivator", "trmysticism:the_balance", "trmysticism:repeater", "trmysticism:gardener", "trmysticism:engineer", "trmysticism:gatekeeper"};
        String startingRacesKey = "startingRaces = [";
        String randomRacesKey = "possibleRandomRaces = [";
        String reincarnationSkillsKey = "reincarnationSkills = [";
        String creatorSkillsKey = "skillCreatorSkills = [";
        content = this.addItemsToTOMLList(content, startingRacesKey, newStarting);
        content = this.addItemsToTOMLList(content, randomRacesKey, newRandom);
        content = this.addItemsToTOMLList(content, reincarnationSkillsKey, newSkills);
        content = this.addItemsToTOMLList(content, creatorSkillsKey, creatorSkills);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tomlFile));){
            writer.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error writing to the TOML file: " + e.getMessage());
        }
        System.out.println("Items added to TOML lists successfully.");
    }

    public void editEngravings() {
        File tomlFile = new File("defaultconfigs/tensura-reincarnated/common.toml");
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(tomlFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                contentBuilder.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error reading the TOML file: " + e.getMessage());
            return;
        }
        String content = contentBuilder.toString();
        String[] commonEngraveNew = new String[]{};
        String[] uncommonEngraveNew = new String[]{};
        String[] rareEngraveNew = new String[]{};
        String[] veryRareEngraveNew = new String[]{};
        String[] blacklistedEngraveNew = new String[]{"trmysticism:genesis"};
        String commonKey = "enchantments.commonEngrave";
        String uncommonKey = "enchantments.uncommonEngrave";
        String rareKey = "enchantments.rareEngrave";
        String veryRareKey = "enchantments.veryRareEngrave";
        String blacklistedKey = "enchantments.researcherEnchant";
        content = this.addItemsToTOMLEngravings(content, commonKey, commonEngraveNew);
        content = this.addItemsToTOMLEngravings(content, uncommonKey, uncommonEngraveNew);
        content = this.addItemsToTOMLEngravings(content, rareKey, rareEngraveNew);
        content = this.addItemsToTOMLEngravings(content, veryRareKey, veryRareEngraveNew);
        content = this.addBlacklistToTOMLEngravings(content, blacklistedKey, blacklistedEngraveNew);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tomlFile));){
            writer.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error writing to the TOML file: " + e.getMessage());
        }
        System.out.println("Engraving enchantments added to TOML successfully.");
    }

    private String addItemsToTOMLEngravings(String content, String enchantmentSection, String[] newItems) {
        int sectionIndex = content.indexOf("[" + enchantmentSection + "]");
        if (sectionIndex == -1) {
            return content;
        }
        int enchantmentsLineStart = content.indexOf("enchantments = [", sectionIndex);
        if (enchantmentsLineStart == -1) {
            return content;
        }
        int lineEnd = content.indexOf("]", enchantmentsLineStart);
        if (lineEnd == -1) {
            return content;
        }
        String currentListStr = content.substring(enchantmentsLineStart + "enchantments = [".length(), lineEnd).trim();
        HashSet<String> currentEnchantments = new HashSet<String>();
        if (!currentListStr.isEmpty()) {
            for (String item : currentListStr.split(",")) {
                currentEnchantments.add(item.trim().replace("\"", ""));
            }
        }
        for (String newItem : newItems) {
            currentEnchantments.add(newItem);
        }
        StringBuilder newEnchantmentsLine = new StringBuilder("enchantments = [");
        boolean first = true;
        for (String enchantment : currentEnchantments) {
            if (!first) {
                newEnchantmentsLine.append(", ");
            }
            newEnchantmentsLine.append("\"").append(enchantment).append("\"");
            first = false;
        }
        newEnchantmentsLine.append("]");
        return content.substring(0, enchantmentsLineStart) + newEnchantmentsLine.toString() + content.substring(lineEnd + 1);
    }

    private String addBlacklistToTOMLEngravings(String content, String enchantmentSection, String[] newItems) {
        int sectionIndex = content.indexOf("[" + enchantmentSection + "]");
        if (sectionIndex == -1) {
            return content;
        }
        int enchantmentsLineStart = content.indexOf("blacklist = [", sectionIndex);
        if (enchantmentsLineStart == -1) {
            return content;
        }
        int lineEnd = content.indexOf("]", enchantmentsLineStart);
        if (lineEnd == -1) {
            return content;
        }
        String currentListStr = content.substring(enchantmentsLineStart + "blacklist = [".length(), lineEnd).trim();
        HashSet<String> currentEnchantments = new HashSet<String>();
        if (!currentListStr.isEmpty()) {
            for (String item : currentListStr.split(",")) {
                currentEnchantments.add(item.trim().replace("\"", ""));
            }
        }
        for (String newItem : newItems) {
            currentEnchantments.add(newItem);
        }
        StringBuilder newEnchantmentsLine = new StringBuilder("blacklist = [");
        boolean first = true;
        for (String enchantment : currentEnchantments) {
            if (!first) {
                newEnchantmentsLine.append(", ");
            }
            newEnchantmentsLine.append("\"").append(enchantment).append("\"");
            first = false;
        }
        newEnchantmentsLine.append("]");
        return content.substring(0, enchantmentsLineStart) + newEnchantmentsLine.toString() + content.substring(lineEnd + 1);
    }

    private String addItemsToTOMLList(String content, String listKey, String[] newItems) {
        int index = content.indexOf(listKey);
        if (index == -1) {
            System.out.println("List identifier '" + listKey + "' not found.");
            return content;
        }
        int endIndex = content.indexOf("]", index) + 1;
        if (endIndex == 0) {
            System.out.println("Closing bracket not found for list: " + listKey);
            return content;
        }
        String listContent = content.substring(index, endIndex);
        for (String newItem : newItems) {
            if (listContent.contains(newItem)) continue;
            listContent = listContent.replace("]", ", \"" + newItem + "\"]");
        }
        return content.replace(content.substring(index, endIndex), listContent);
    }
}

