/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.magic.spiritual.space;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import com.github.manasmods.tensura.entity.magic.barrier.DarkCubeEntity;
import io.github.Memoires.trmysticism.entity.magic.SpatialCubeEntity;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpatialVoidMagic
extends SpiritualMagic {
    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/magic/spiritual/space/spatial_void.png");
    }

    public SpatialVoidMagic() {
        super(MagicElemental.SPACE, SpiritualMagic.SpiritLevel.LORD);
    }

    public int defaultCast() {
        return 600;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 500000.0;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onHeld(instance, entity, heldTicks);
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(30.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
        if (!list.isEmpty()) {
            for (LivingEntity target : list) {
                target.m_147207_(new MobEffectInstance((MobEffect)MysticismMobEffects.SPATIAL_COLLAPSE.get(), 100, 0, false, false, false), (Entity)entity);
            }
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (MobEffectHelper.noTeleportation((LivingEntity)entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
        } else if (this.getHeldTicks(instance) >= this.castingTime(instance, entity) && !SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Vec3 pos;
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            this.addMasteryPoint(instance, entity);
            int distance = instance.isMastered(entity) ? 20 : 15;
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)distance, (boolean)false, (boolean)true);
            if (target != null) {
                pos = target.m_20096_() ? target.m_20182_().m_82520_(0.0, 4.5, 0.0) : target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            } else {
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)entity.f_19853_, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)distance);
                pos = result.m_82450_().m_82520_(0.0, 4.5, 0.0);
            }
            SpatialCubeEntity cube = new SpatialCubeEntity(entity.m_9236_(), entity);
            cube.m_146884_(pos);
            cube.setDamage(instance.isMastered(entity) ? 2000.0f : 750.0f);
            cube.setMpCost(this.magiculeCost(entity, instance));
            cube.setSkill(instance);
            cube.setLife(600);
            cube.setRadius(5.0f);
            entity.m_9236_().m_7967_((Entity)cube);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
            instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
            instance.getOrCreateTag().m_128405_("HeldTicks", 0);
            instance.markDirty();
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        DarkCubeEntity barrier;
        BarrierEntity var5;
        BarrierPart part;
        if (entity.m_6144_() && (part = (BarrierPart)SkillHelper.getTargetingEntity(BarrierPart.class, (LivingEntity)entity, (double)20.0, (double)0.1, (boolean)false, (boolean)false)) != null && (var5 = part.barrier) instanceof DarkCubeEntity && (barrier = (DarkCubeEntity)var5).m_37282_() == entity) {
            barrier.m_146870_();
            entity.f_19853_.m_6263_((Player)null, part.m_20185_(), part.m_20186_(), part.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

