/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.magic.summon;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.magic.summon.SummoningMagic;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.api.entity.subclass.ISummonable;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;

public abstract class SummonDarkLightElementalMagic
extends SummoningMagic<TamableAnimal> {
    private final SpiritualMagic.SpiritLevel level;
    private static final List<MagicElemental> ALLOWED_SPIRITS = List.of(MagicElemental.DARKNESS, MagicElemental.LIGHT);

    public SummonDarkLightElementalMagic(SpiritualMagic.SpiritLevel level) {
        this.level = level;
    }

    public int defaultCast() {
        return 100;
    }

    public int masteryCast() {
        return 60;
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent event) {
        instance.setMode(0);
    }

    public int modes() {
        return 2;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (!(entity instanceof Player)) {
            return 0;
        }
        Player player = (Player)entity;
        int currentSpiritIndex = instance.getMode() - 1;
        int nextMode = 0;
        for (int tries = 0; nextMode == 0 && tries < ALLOWED_SPIRITS.size(); ++tries) {
            currentSpiritIndex = reverse ? (currentSpiritIndex - 1 + ALLOWED_SPIRITS.size()) % ALLOWED_SPIRITS.size() : (currentSpiritIndex + 1) % ALLOWED_SPIRITS.size();
            if (!this.containsSpirit(instance, player, currentSpiritIndex)) continue;
            nextMode = currentSpiritIndex + 1;
        }
        return nextMode;
    }

    private boolean containsSpirit(TensuraSkillInstance instance, Player player, int spirit) {
        int level = this.getLevel().getId();
        List elementals = MagicElemental.getCommonElementals();
        if (TensuraSkillCapability.getSpiritLevel((Player)player, (int)((MagicElemental)elementals.get(spirit)).getId()) >= level) {
            return true;
        }
        CompoundTag tag = instance.getTag();
        if (tag == null) {
            return false;
        }
        if (!tag.m_128441_("SpiritTamed")) {
            return false;
        }
        return tag.m_128469_("SpiritTamed").m_128451_(((MagicElemental)MagicElemental.getCommonElementals().get(spirit)).getNamespace()) >= level;
    }

    public static void addSpiritSummonLevel(ManasSkillInstance instance, IElementalSpirit spirit) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("SpiritTamed")) {
            CompoundTag spiritTamed = tag.m_128469_("SpiritTamed");
            int currentLevel = spiritTamed.m_128451_(spirit.getElemental().getNamespace());
            if (currentLevel >= spirit.getSpiritLevel().getId()) {
                return;
            }
            spiritTamed.m_128405_(spirit.getElemental().getNamespace(), spirit.getSpiritLevel().getId());
            instance.markDirty();
        } else {
            CompoundTag spiritTamed = new CompoundTag();
            spiritTamed.m_128405_(spirit.getElemental().getNamespace(), spirit.getSpiritLevel().getId());
            tag.m_128365_("SpiritTamed", (Tag)spiritTamed);
            instance.markDirty();
        }
    }

    protected int getSuccessCooldown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity) ? 3600 : 6000;
    }

    protected void removeExistingSummon(ManasSkillInstance instance, LivingEntity entity) {
        TamableAnimal summon = (TamableAnimal)SkillHelper.getTargetingEntity(TamableAnimal.class, (LivingEntity)entity, (double)30.0, (double)0.2, (boolean)false);
        if (summon != null && summon instanceof IElementalSpirit) {
            IElementalSpirit spirit = (IElementalSpirit)summon;
            if (summon.m_21830_(entity) && spirit.getSummoningTick() >= 0 && spirit.getSpiritLevel() == this.getLevel()) {
                summon.m_6469_(TensuraDamageSources.noEnergySource((Entity)entity), summon.m_21233_());
                instance.setCoolDown(0);
            }
        }
    }

    protected void addAdditionalSummonData(ManasSkillInstance instance, LivingEntity entity, TamableAnimal summon) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            summon.m_21828_(player);
        }
        if (summon instanceof ISummonable) {
            ISummonable summonable = (ISummonable)summon;
            summonable.setSummoningTick(6000);
        }
        summon.m_217045_();
    }

    protected ResourceLocation getSummoningFxLocation(ManasSkillInstance instance) {
        String name = ((MagicElemental)MagicElemental.getCommonElementals().get(instance.getMode() - 1)).getNamespace();
        if (instance.getMode() == 1) {
            return new ResourceLocation("tensura:dark_circle");
        }
        return new ResourceLocation("tensura:light_circle");
    }

    protected ParticleOptions getSummoningParticle(ManasSkillInstance instance) {
        return (ParticleOptions)(switch (instance.getMode()) {
            case 1 -> (SimpleParticleType)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get();
            case 2 -> (SimpleParticleType)TensuraParticles.YELLOW_LIGHTNING_SPARK.get();
            default -> (SimpleParticleType)TensuraParticles.YELLOW_LIGHTNING_SPARK.get();
        });
    }

    protected SoundEvent getSummoningSound(ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> SoundEvents.f_215776_;
            case 2 -> SoundEvents.f_11785_;
            default -> SoundEvents.f_11785_;
        };
    }

    protected SoundEvent getFailSound(ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> SoundEvents.f_215779_;
            case 2 -> SoundEvents.f_11787_;
            default -> SoundEvents.f_11787_;
        };
    }

    public SpiritualMagic.SpiritLevel getLevel() {
        return this.level;
    }
}

