/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DarknessDominationSkill
extends Skill {
    public DarknessDominationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/extra/darkness_domination.png");
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 200.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)((ManasSkill)ExtraSkills.DARKNESS_MANIPULATION.get()))) {
            return false;
        }
        return newEP > 2000000.0;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled() && DamageSourceHelper.isDarkDamage((DamageSource)e.getSource())) {
            e.setAmount(e.getAmount() * 4.0f);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (heldTicks % 100 == 0 && heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            double cost = this.magiculeCost(entity, instance);
            this.spawnDarkBeam(player, instance, cost);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 0.8f, 0.5f);
        }
        return true;
    }

    private void spawnDarkBeam(Player player, ManasSkillInstance instance, double cost) {
        if (player.m_21023_((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get())) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.magic_interference").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
            return;
        }
        BeamProjectile.spawnLastingBeam((EntityType)((EntityType)TensuraEntityTypes.DARKNESS_CANNON.get()), (float)20.0f, (float)1.0f, (LivingEntity)player, (ManasSkillInstance)instance, (double)cost, (double)cost, (int)0);
    }
}

