/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.MolecularManipulationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import com.github.manasmods.tensura.entity.magic.barrier.DarkCubeEntity;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DarknessManipulationSkill
extends Skill {
    public DarknessManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/extra/darkness_manipulation.png");
    }

    public double learningCost() {
        return 100.0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        return DarknessManipulationSkill.learnDarkManipulation((LivingEntity)entity) || TensuraSkillCapability.getSpiritLevel((Player)entity, (int)MagicElemental.DARKNESS.getId()) >= 1;
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        MolecularManipulationSkill.learnMolecular((LivingEntity)entity);
        if (!(TensuraEPCapability.getEP((LivingEntity)entity) < 400000.0)) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            ManasSkill skill = (ManasSkill)ExtraSkills.DARKNESS_DOMINATION.get();
            TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
            manipulation.setMastery(-100);
            if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            }
        }
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 1000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled() && !SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.DARKNESS_DOMINATION.get())) && DamageSourceHelper.isDarkDamage((DamageSource)e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        DarkCubeEntity barrier;
        BarrierEntity var5;
        BarrierPart part;
        if (entity.m_6144_() && (part = (BarrierPart)SkillHelper.getTargetingEntity(BarrierPart.class, (LivingEntity)entity, (double)20.0, (double)0.1, (boolean)false, (boolean)false)) != null && (var5 = part.barrier) instanceof DarkCubeEntity && (barrier = (DarkCubeEntity)var5).m_37282_() == entity) {
            barrier.m_146870_();
            entity.f_19853_.m_6263_((Player)null, part.m_20185_(), part.m_20186_(), part.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (!entity.m_6144_() && !SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Vec3 pos;
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            this.addMasteryPoint(instance, entity);
            int distance = instance.isMastered(entity) ? 20 : 15;
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)distance, (boolean)false, (boolean)true);
            if (target != null) {
                pos = target.m_20096_() ? target.m_20182_().m_82520_(0.0, 4.5, 0.0) : target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            } else {
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)entity.f_19853_, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)distance);
                pos = result.m_82450_().m_82520_(0.0, 4.5, 0.0);
            }
            DarkCubeEntity cube = new DarkCubeEntity(entity.m_9236_(), entity);
            cube.m_146884_(pos);
            cube.setDamage(instance.isMastered(entity) ? 40.0f : 20.0f);
            cube.setMpCost(this.magiculeCost(entity, instance));
            cube.setSkill(instance);
            cube.setLife(600);
            cube.setRadius(5.0f);
            entity.m_9236_().m_7967_((Entity)cube);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
            instance.setCoolDown(instance.isMastered(entity) ? 2 : 4);
            instance.markDirty();
        }
    }

    public static boolean learnDarkManipulation(LivingEntity entity) {
        int skills = 0;
        for (ManasSkillInstance skill : SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills()) {
            if (!DarknessManipulationSkill.isDarkSkill(skill, entity)) continue;
            ++skills;
        }
        return skills >= 3;
    }

    private static boolean isDarkSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isMastered(entity)) {
            return false;
        }
        return instance.getSkill().equals(SpiritualMagics.DARKNESS.get()) ? true : (instance.getSkill().equals(SpiritualMagics.SHADOW_BIND.get()) ? true : (instance.getSkill().equals(SpiritualMagics.DARK_CUBE.get()) ? true : (instance.getSkill().equals(SpiritualMagics.TRUE_DARKNESS.get()) ? true : (instance.getSkill().equals(SpiritualMagics.DARKNESS_CANNON.get()) ? true : instance.getSkill().equals(IntrinsicSkills.DARKNESS_TRANSFORM.get())))));
    }
}

