/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.MolecularManipulationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class IceManipulationSkill
extends Skill {
    public IceManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/extra/ice_manipulation.png");
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        MolecularManipulationSkill.learnMolecular((LivingEntity)entity);
        if (!(TensuraEPCapability.getEP((LivingEntity)entity) < 400000.0)) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            ManasSkill skill = (ManasSkill)ExtraSkills.ICE_DOMINATION.get();
            TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
            manipulation.setMastery(-100);
            if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            }
        }
    }

    public double learningCost() {
        return 100.0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        return IceManipulationSkill.learnIceManipulation((LivingEntity)entity);
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 200.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled() && !SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.ICE_DOMINATION.get()))) {
            if (DamageSourceHelper.isCold((DamageSource)e.getSource())) {
                e.setAmount(e.getAmount() * 2.0f);
            }
            this.addMasteryPoint(instance, living);
        }
    }

    public static boolean learnIceManipulation(LivingEntity entity) {
        int skills = 0;
        for (ManasSkillInstance skill : SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills()) {
            if (!IceManipulationSkill.isIceSkill(skill, entity)) continue;
            ++skills;
        }
        return skills >= 1;
    }

    private static boolean isIceSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isMastered(entity)) {
            return false;
        }
        return instance.getSkill().equals(SpiritualMagics.BLIZZARD.get()) || instance.getSkill().equals(ExtraSkills.CRYOGENIC_CESSATION.get());
    }
}

