/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LightAndHeatDominationSkill
extends Skill {
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/extra/light_and_heat_domination.png");
    }

    public int modes() {
        return 3;
    }

    public LightAndHeatDominationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 100;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled() && (DamageSourceHelper.isFireDamage((DamageSource)e.getSource()) || DamageSourceHelper.isLightDamage((DamageSource)e.getSource()))) {
            e.setAmount(e.getAmount() * 8.0f);
            this.addMasteryPoint(instance, living);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        float damage = instance.isMastered(entity) ? 20.0f : 10.0f;
        BreathEntity.spawnBreathEntity((EntityType)((EntityType)TensuraEntityTypes.BLACK_FLAME_BREATH.get()), (LivingEntity)entity, (ManasSkillInstance)instance, (float)damage, (double)this.magiculeCost(entity, instance));
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        switch (instance.getMode()) {
            case 1: {
                instance.getOrCreateTag().m_128405_("BreathEntity", 0);
                instance.markDirty();
            }
        }
    }
}

