/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.projectile.LightArrowProjectile;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LightDominationSkill
extends Skill {
    public LightDominationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/extra/light_domination.png");
    }

    public double learningCost() {
        return 100.0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)((ManasSkill)ExtraSkills.LIGHT_MANIPULATION.get()))) {
            return false;
        }
        return newEP > 2000000.0;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 8000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled() && !SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.LIGHT_AND_HEAT_DOMINATION.get())) && DamageSourceHelper.isLightDamage((DamageSource)e.getSource())) {
            e.setAmount(e.getAmount() * 4.0f);
        }
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Vec3 pos;
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            this.addMasteryPoint(instance, entity);
            Level level = entity.m_9236_();
            int distance = instance.isMastered(entity) ? 30 : 20;
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)distance, (boolean)false, (boolean)true);
            if (target != null) {
                pos = target.m_146892_();
            } else {
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)entity.f_19853_, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)distance);
                pos = result.m_82450_().m_82520_(0.0, 0.5, 0.0);
            }
            if (instance.isMastered(entity)) {
                this.spawnLightArrows(instance, entity, pos, 10, 2.0);
                this.spawnLightArrows(instance, entity, pos, 10, 4.0);
            } else {
                this.spawnLightArrows(instance, entity, pos, 10, 3.0);
            }
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private void spawnLightArrows(ManasSkillInstance instance, LivingEntity entity, Vec3 pos, int arrowAmount, double distance) {
        int arrowRot = 360 / arrowAmount;
        for (int i = 0; i < arrowAmount; ++i) {
            Vec3 arrowPos = entity.m_146892_().m_82549_(new Vec3(0.0, distance, 0.0).m_82535_(((float)(arrowRot * i) - (float)arrowRot / 2.0f) * ((float)Math.PI / 180)).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180)));
            LightArrowProjectile arrow = new LightArrowProjectile(entity.m_9236_(), entity);
            arrow.setSpeed(2.0f);
            arrow.m_146884_(arrowPos);
            arrow.shootFromRot(pos.m_82546_(arrowPos).m_82541_());
            arrow.setLife(50);
            arrow.setDamage(60.0f);
            arrow.setMpCost(this.magiculeCost(entity, instance) / (double)arrowAmount);
            arrow.setSpiritAttack(true);
            arrow.setSkill(instance);
            entity.m_9236_().m_7967_((Entity)arrow);
        }
    }
}

