/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.MolecularManipulationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LightManipulationSkill
extends Skill {
    public LightManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/extra/light_manipulation.png");
    }

    public double learningCost() {
        return 100.0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        return LightManipulationSkill.learnLightManipulation((LivingEntity)entity) || TensuraSkillCapability.getSpiritLevel((Player)entity, (int)MagicElemental.LIGHT.getId()) >= 1;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 200.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled() && !SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.LIGHT_DOMINATION.get())) && !SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.LIGHT_AND_HEAT_DOMINATION.get())) && DamageSourceHelper.isLightDamage((DamageSource)e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        MolecularManipulationSkill.learnMolecular((LivingEntity)entity);
        if (!(TensuraEPCapability.getEP((LivingEntity)entity) < 400000.0)) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            ManasSkill skill = (ManasSkill)ExtraSkills.LIGHT_DOMINATION.get();
            TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
            manipulation.setMastery(-100);
            if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (heldTicks % 100 == 0 && heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            double cost = this.magiculeCost(entity, instance);
            this.spawnSolarBeam(player, instance, cost);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 0.8f, 0.5f);
        }
        return true;
    }

    private void spawnSolarBeam(Player player, ManasSkillInstance instance, double cost) {
        if (player.m_21023_((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get())) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.magic_interference").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
            return;
        }
        BeamProjectile.spawnLastingBeam((EntityType)((EntityType)TensuraEntityTypes.SOLAR_BEAM.get()), (float)20.0f, (float)1.0f, (LivingEntity)player, (ManasSkillInstance)instance, (double)cost, (double)cost, (int)0);
    }

    public static boolean learnLightManipulation(LivingEntity entity) {
        int skills = 0;
        Iterator var2 = SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills().iterator();
        for (ManasSkillInstance skill : SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills()) {
            if (!LightManipulationSkill.isLightSkill(skill, entity)) continue;
            ++skills;
        }
        return skills >= 3;
    }

    private static boolean isLightSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isMastered(entity)) {
            return false;
        }
        return instance.getSkill().equals(SpiritualMagics.LIGHT.get()) || instance.getSkill().equals(SpiritualMagics.SOLAR_BEAM.get()) || instance.getSkill().equals(SpiritualMagics.SOLAR_WAVE.get()) || instance.getSkill().equals(SpiritualMagics.SOLAR_RAIN.get()) || instance.getSkill().equals(SpiritualMagics.SOLAR_FLARE.get()) || instance.getSkill().equals(IntrinsicSkills.LIGHT_TRANSFORM.get());
    }
}

