/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ManaManipulationSkill
extends Skill {
    public ManaManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/extra/mana_manipulation.png");
    }

    public double learningCost() {
        return 1000.0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        return SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)((ManasSkill)ExtraSkills.MAGIC_JAMMING.get())) && SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)((ManasSkill)ExtraSkills.MOLECULAR_MANIPULATION.get()));
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        if (instance.isToggled()) {
            DamageSource source = event.getSource();
            if (DamageSourceHelper.isSoundDamage((DamageSource)source) || DamageSourceHelper.isNaturalEffects((DamageSource)source)) {
                if (instance.isMastered(entity)) {
                    event.setAmount(event.getAmount() * 1.4f);
                } else {
                    event.setAmount(event.getAmount() * 1.2f);
                }
            }
            if (DamageSourceHelper.isTensuraMagic((DamageSource)source)) {
                if (instance.isMastered(entity)) {
                    event.setAmount(event.getAmount() * 2.5f);
                } else {
                    event.setAmount(event.getAmount() * 2.0f);
                }
            }
        }
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        DamageSource source;
        if (instance.isToggled() && (DamageSourceHelper.isTensuraMagic((DamageSource)(source = event.getSource())) || DamageSourceHelper.isSoundDamage((DamageSource)source) || DamageSourceHelper.isCorrosion((DamageSource)source) || DamageSourceHelper.isNaturalEffects((DamageSource)source))) {
            event.setAmount(event.getAmount() / 2.0f);
        }
    }

    public int modes() {
        return 2;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.mana_manipulation.global_magic_interference");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.mana_manipulation.local_magic_interference");
            default -> Component.m_237119_();
        };
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 300.0;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return false;
            }
            Level level = entity.m_9236_();
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)10.0, (boolean)false);
            if (target != null) {
                int duration;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return false;
                    }
                }
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 0.5f, 1.0f);
                int i = 0;
                int originalDuration = instance.isMastered(entity) ? 500 : 300;
                MobEffectInstance magicInterf = target.m_21124_((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get());
                if (magicInterf != null && heldTicks > 0) {
                    duration = magicInterf.m_19557_() + 2;
                    i = (duration - originalDuration) / 150;
                } else {
                    duration = originalDuration;
                }
                SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get()), (int)duration, (int)i, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
            }
            return true;
        }
        return false;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 2) {
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return;
            }
            Level level = entity.m_9236_();
            float radius = instance.isMastered(entity) ? 30.0f : 20.0f;
            List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
            if (!list.isEmpty()) {
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                this.addMasteryPoint(instance, entity);
                for (LivingEntity target1 : list) {
                    if (target1 instanceof Player) {
                        Player player = (Player)target1;
                        if (player.m_150110_().f_35934_) continue;
                    }
                    int duration = instance.isMastered(entity) ? 500 : 200;
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target1, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    entity.m_21219_();
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target1, (ParticleOptions)ParticleTypes.f_123762_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target1, (ParticleOptions)ParticleTypes.f_123808_, (double)1.0);
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }
}

