/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class ProfanedProminenceSkill
extends Skill {
    public ProfanedProminenceSkill() {
        super(Skill.SkillType.EXTRA);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/extra/profaned_prominence.png");
    }

    public double learningCost() {
        return 500.0;
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMode() == 1;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return false;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        DamageSource source;
        if (this.isInSlot(attacker) && (source = e.getSource()).m_7640_() == attacker && DamageSourceHelper.isFireDamage((DamageSource)source)) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (this.isInSlot(attacker) && (DamageSourceHelper.isPhysicalAttack((DamageSource)e.getSource()) || e.getSource().m_7639_() instanceof AbstractArrow)) {
            LivingEntity target = e.getEntity();
            this.addMasteryPoint(instance, attacker);
            target.m_20254_(this.isMastered(instance, attacker) ? 10 : 5);
            attacker.m_9236_().m_6263_((Player)null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11909_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123744_, (double)1.0);
        }
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 1000.0;
            default -> 500.0;
        };
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.profaned_prominence.fire_breath");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.profaned_prominence.providence");
            default -> Component.m_237119_();
        };
    }

    public int modes() {
        return 2;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return false;
            }
            if (heldTicks % 100 == 0 && heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            float damage = instance.isMastered(entity) ? 32.0f : 16.0f;
            BreathEntity.spawnBreathEntity((EntityType)((EntityType)TensuraEntityTypes.FLAME_BREATH.get()), (LivingEntity)entity, (ManasSkillInstance)instance, (float)damage, (double)this.magiculeCost(entity, instance));
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)10.0);
            if (instance.getMode() == 2 && TensuraGameRules.canSkillGrief((Level)level)) {
                BlockState currentState;
                BlockPos newPos;
                int y;
                int z;
                int x;
                BlockPos pos = entity.m_20097_();
                int radius = 8;
                boolean success = false;
                boolean waterDetected = false;
                for (x = -radius; x <= radius; ++x) {
                    for (z = -radius; z <= radius; ++z) {
                        for (y = -radius * 2; y <= 0; ++y) {
                            newPos = pos.m_7918_(x, y, z);
                            currentState = level.m_8055_(newPos);
                            if (!currentState.m_60713_(Blocks.f_49990_)) continue;
                            waterDetected = true;
                            break;
                        }
                        if (waterDetected) break;
                    }
                    if (waterDetected) break;
                }
                if (!waterDetected) {
                    for (x = -radius; x <= radius; ++x) {
                        for (z = -radius; z <= radius; ++z) {
                            for (y = -radius * 2; y <= 0; ++y) {
                                SkillGriefEvent.Pre preGrief;
                                newPos = pos.m_7918_(x, y, z);
                                currentState = level.m_8055_(newPos);
                                if (currentState.m_60795_() || !(currentState.m_60800_((BlockGetter)level, newPos) >= 0.0f) || MinecraftForge.EVENT_BUS.post((Event)(preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, newPos)))) continue;
                                level.m_7731_(newPos, Blocks.f_49991_.m_49966_(), 3);
                                success = true;
                            }
                        }
                    }
                    if (success) {
                        this.addMasteryPoint(instance, entity);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        if (!instance.isMastered(entity)) {
                            instance.setCoolDown(20);
                        } else {
                            instance.setCoolDown(10);
                        }
                    }
                }
            }
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_21195_((MobEffect)TensuraMobEffects.MAGICULE_POISON.get());
    }
}

